/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_tabweather_properties.h
* @brief       Declaration of the Tabweather service properties
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_TABWEATHER_PROPERTIES_H
#define FC_SXM_TCL_TABWEATHER_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_tabweather_fi.h"

/*
  Semaphore-protected data of Tabweather-app
*/


// example for property, where fi-type is stored directly in member "oFiMsg"
struct fc_sxm_tcl_trTabweatherPropertyNewUpdateTabweatherInfoListStatus {
    fc_sxm_tcl_trTabweatherPropertyNewUpdateTabweatherInfoListStatus(tBool bUpdateTabweather_=FALSE)
    {
    	(void)bUpdateTabweather_; // to solve prio2 lint info 715
    }
    tBool operator!=(fc_sxm_tcl_trTabweatherPropertyNewUpdateTabweatherInfoListStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }

    midw_ext_sxm_tabweatherfi_tclMsgTabWeatherInfoListStatusStatus oFiMsg;
 
};

struct fc_sxm_tcl_trTabweatherPropertySxmServiceStatus {
    fc_sxm_tcl_trTabweatherPropertySxmServiceStatus()
    {}
    bool operator!=(fc_sxm_tcl_trTabweatherPropertySxmServiceStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }

    midw_ext_sxm_tabweatherfi_tclMsgSxmDataServiceStatusStatus oFiMsg;
 
};

struct fc_sxm_tcl_trTabweatherPropertySxmListMode {
    	fc_sxm_tcl_trTabweatherPropertySxmListMode()
        {}
        bool operator!=(fc_sxm_tcl_trTabweatherPropertySxmListMode const& b) const
        {
            return !(oFiMsg==b.oFiMsg);
        }

        midw_ext_sxm_tabweatherfi_tclMsgSxmListModeStatus oFiMsg;
 
};


    class fc_sxm_tclTabweatherProperties:
    public fc_sxm_tclSingleton<fc_sxm_tclTabweatherProperties>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclTabweatherProperties>;
 public:

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trTabweatherPropertyNewUpdateTabweatherInfoListStatus, 
        CCA_C_U16_SRV_SXM_TABULAR_WEATHER, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_TABWEATHERFI_C_U16_TABWEATHERINFOLISTSTATUS /* give FID if notification to service is needed  */
        > oNewUpdateTabweatherInfoListStatus;

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trTabweatherPropertySxmServiceStatus, 
        CCA_C_U16_SRV_SXM_TABULAR_WEATHER, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_TABWEATHERFI_C_U16_SXMDATASERVICESTATUS /* give FID if notification to service is needed  */
        > oSxmServiceStatus;

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trTabweatherPropertySxmListMode,
           CCA_C_U16_SRV_SXM_TABULAR_WEATHER, /*the service-id of the CCA-Service */
		   MIDW_EXT_SXM_TABWEATHERFI_C_U16_SXMLISTMODE /* give FID if notification to service is needed  */
           > oSxmListMode;
};


#endif
