/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_tabweather_dsrl.h
* @brief       Declaration of the Tabweather DSRL functionalities.
               It invokes the SMS libraries and copied into the internal list.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/
#ifndef _FC_SXM_TCL_TABWEATHER_DSRL_H_
#define _FC_SXM_TCL_TABWEATHER_DSRL_H_

#include "fc_sxm_tcl_base_dsrl.h"
#include "fc_sxm_tabweather_types.h"

// Forward declaration for TabWeatherTypeListEntry
struct fc_sxm_trTabweatherTypeListEntry;
// tabweather-specific configuration of dsrl
struct fc_sxm_trTabweatherDSRLCfg: public fc_sxm_trDSRLBaseCfg
{
	fc_sxm_trTabweatherDSRLCfg(){
		//to solve lint warning 1401
		rFilterCfg.enWeatherMsgObjectType = WEATHER_MSG_TYPE_INVALID;
		enSortMethod = fc_sxm_enTabweatherSortMethod_NONE;
	}
    fc_sxm_trTabweatherDSRLCfg(fc_sxm_trDSRLGenericCfg const &rGenericCfg) {
        u32Capacity=rGenericCfg.u32Capacity;
        rLocation=rGenericCfg.rLocation; /*Lat,Lon,Radius*/
        u32Radius=rGenericCfg.u32Radius;
        enSortMethod=(fc_sxm_tenTabweatherSortMethod)rGenericCfg.u8SortMethod;
		rFilterCfg.enWeatherMsgObjectType=(WEATHER_MSG_OBJECT_TYPE_ENUM)rGenericCfg.u8FilterMethod;
    }
    virtual tVoid vPrintSpecific() const;
	fc_sxm_trTabweatherDSRLFilterCfg rFilterCfg;
	fc_sxm_tenTabweatherSortMethod enSortMethod;
};


class fc_sxm_tclTabweatherDSRL : 
   public fc_sxm_tclConfigDSRL<fc_sxm_trTabweatherDSRLCfg> 
{

public:
   // Constuctor
   fc_sxm_tclTabweatherDSRL(fc_sxm_tenDSRLType enDsrlType);

   //Destructor
   virtual ~fc_sxm_tclTabweatherDSRL();

   //Update notification when the DSRL is ready and iterated
   virtual tVoid vOnDSRLUpdate(tVoid);

   virtual tBool bHandleFilterCallback(DSRL_OBJECT hDSRL, 
                                       DSRL_ENTRY_OBJECT hEntry);
   
   virtual tS16 s16HandleSortCallback(DSRL_OBJECT hDSRL,
                                      DSRL_ENTRY_OBJECT hEntry1,
                                      DSRL_ENTRY_OBJECT hEntry2);
   
   virtual tBool bHandleIterateCallback(DSRL_OBJECT hDSRL, 
                                        DSRL_ENTRY_ID tEntryID,
                                        DSRL_ENTRY_STATUS_ENUM eStatus,
                                        DSRL_ENTRY_OBJECT hEntryObject);

   virtual tVoid vHandleDsrlEntryInvalid (DSRL_ENTRY_ID tEntryID);

private:
   tVoid vWeatherEventForecast ( FORECAST_OBJECT hForecast, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
   tVoid vTemperatureForecast ( FORECAST_OBJECT hForecast, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
   tVoid vPrecipitationForecast ( FORECAST_OBJECT hForecast, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
   tVoid vWindForecast ( FORECAST_OBJECT hForecast, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
   tVoid vHumidityForecast ( FORECAST_OBJECT hForecast, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
   tVoid vUVInfoForecast ( FORECAST_OBJECT hForecast, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
   tVoid vAirForecast ( FORECAST_OBJECT hForecast, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
   tVoid vCloudCoverForecast ( FORECAST_OBJECT hForecast, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
   tVoid vTimeStampForecast ( FORECAST_OBJECT hForecast, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
   tVoid vLocationInfo ( LOCATION_OBJECT hLocation, fc_sxm_trTabweatherTypeListEntry& rEntry) const;
};

#endif //_FC_SXM_TCL_TABWEATHER_DSRL_H_
