/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tabweather_types.h
* @brief       Declaration of the Tabweather Types and includes the SMS library
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef FC_SXM_TABWEATHER_TYPES_H
#define FC_SXM_TABWEATHER_TYPES_H

#include "fc_sxm_sms.h"


// SMS-default sort-method must have number 0
typedef enum
{
   fc_sxm_enTabweatherSortMethod_NONE = 0
   
} fc_sxm_tenTabweatherSortMethod;

typedef enum
{
   fc_sxm_enTabweatherFilterMethod_WEATHER = 0,
   fc_sxm_enTabweatherFilterMethod_SKI_REPORT,
   fc_sxm_enTabweatherMsgTypeInvalid
//WEATHER_MSG_TYPE_FORECAST,
//WEATHER_MSG_TYPE_SKI_REPORT,
//WEATHER_MSG_TYPE_INVALID
} fc_sxm_tenTabweatherFilterMethod;


// filter-configuration must provide operator!=
struct fc_sxm_trTabweatherDSRLFilterCfg {
	WEATHER_MSG_OBJECT_TYPE_ENUM enWeatherMsgObjectType;
    // to check if filter has changed, configuration has to provice operator!= 
    tBool operator!=(fc_sxm_trTabweatherDSRLFilterCfg const &b) const {
		SXM_RET_1_IF_NEQ(enWeatherMsgObjectType);
        return FALSE;
    }

};


#endif
