/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_stocks_properties.h
* @brief       Declaration of messages used for property notifications for Stocks service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_STOCKS_PROPERTIES_H
#define FC_SXM_TCL_STOCKS_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_stocks_fi.h"

/*
   Semaphore-protected data of stocks-app
 */

// example for property, where fi-type is stored directly in member "oFiMsg"

	struct fc_sxm_tcl_trStocksPropertyStockStatus {
		fc_sxm_tcl_trStocksPropertyStockStatus()
		{ /** Default constructor **/ }

		bool operator!=(fc_sxm_tcl_trStocksPropertyStockStatus const& b) const
		{
			/** Overloaded "!=" operator**/
			return !(oFiMsg==b.oFiMsg);
		}
		midw_ext_sxm_stocksfi_tclMsgStockStatusStatus oFiMsg;
	};

	struct fc_sxm_tcl_trStocksPropertySxmServiceStatus {
		fc_sxm_tcl_trStocksPropertySxmServiceStatus()
		{ /** Default constructor **/ }

		bool operator!=(fc_sxm_tcl_trStocksPropertySxmServiceStatus const& b) const
		{
			/** Overloaded "!=" operator**/
			return !(oFiMsg==b.oFiMsg);
		}
		midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus oFiMsg;
	};

	struct fc_sxm_tcl_trStocksPropertySxmStocksDataProviderInfoStatus {
		fc_sxm_tcl_trStocksPropertySxmStocksDataProviderInfoStatus()
		{ /** Default constructor **/ }

		bool operator!=(fc_sxm_tcl_trStocksPropertySxmStocksDataProviderInfoStatus const& b) const
		{
			/** Overloaded "!=" operator**/
			return !(oFiMsg==b.oFiMsg);
		}
		midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus oFiMsg;
	};

	struct fc_sxm_tcl_trStocksPropertySxmListMode {
		fc_sxm_tcl_trStocksPropertySxmListMode()
			{ /** Default constructor **/ }

			bool operator!=(fc_sxm_tcl_trStocksPropertySxmListMode const& b) const
			{
				/** Overloaded "!=" operator**/
				return !(oFiMsg==b.oFiMsg);
			}
			midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus oFiMsg;
		};

class fc_sxm_tclStocksProperties:
	public fc_sxm_tclSingleton<fc_sxm_tclStocksProperties>
{
	friend class fc_sxm_tclSingleton<fc_sxm_tclStocksProperties>;
 public:
	fc_sxm_tclAutoProperty<fc_sxm_tcl_trStocksPropertyStockStatus,
		CCA_C_U16_SRV_SXM_STOCKS, /*the service-id of the CCA-Service */
		MIDW_EXT_SXM_STOCKSFI_C_U16_STOCKSTATUS /* give FID if notification to service is needed  */
			> oStockStatus;

	fc_sxm_tclAutoProperty<fc_sxm_tcl_trStocksPropertySxmServiceStatus,
		CCA_C_U16_SRV_SXM_STOCKS, /*the service-id of the CCA-Service */
		MIDW_EXT_SXM_STOCKSFI_C_U16_SXMDATASERVICESTATUS /* give FID if notification to service is needed  */
			> oSxmServiceStatus;

	fc_sxm_tclAutoProperty<fc_sxm_tcl_trStocksPropertySxmStocksDataProviderInfoStatus,
		CCA_C_U16_SRV_SXM_STOCKS, /*the service-id of the CCA-Service */
		MIDW_EXT_SXM_STOCKSFI_C_U16_SXMSTOCKSDATAPROVIDERINFOSTATUS /* give FID if notification to service is needed  */
			> oSxmStocksDataProviderInfoStatus;

	fc_sxm_tclAutoProperty<fc_sxm_tcl_trStocksPropertySxmListMode,
		CCA_C_U16_SRV_SXM_STOCKS, /*the service-id of the CCA-Service */
		MIDW_EXT_SXM_STOCKSFI_C_U16_SXMLISTMODE /* give FID if notification to service is needed  */
			> oSxmListMode;
};

#endif
