/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_stocks_types.h
* @brief       Declaration of the Stocks Types and includes the SMS library.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_STOCKS_TYPES_H
#define FC_SXM_STOCKS_TYPES_H

#include "fc_sxm_sms.h"
#include "fc_sxm_tcl_base_dsrl.h"


typedef enum
{
   fc_sxm_enStocksDSRLSortMethod_NONE = 0,
   fc_sxm_enStocksDSRLSortMethod_ALPHABET,
   fc_sxm_enStocksDSRLSortMethod_FIRST_SAVED_FIRST,
   fc_sxm_enStocksDSRLSortMethod_INVALID
} fc_sxm_tenStocksDSRLSortMethod;

typedef enum
{
   fc_sxm_enStocksDSRLFilterConfig_NONE = 0,
   /* Would be required if the dsrl for stocks has to be implemented using device dsrl*/
   fc_sxm_enStocksDSRLFilterConfig_Favorites = 1, 
   fc_sxm_enStocksDSRLFilterConfig_INVALID = 2
} fc_sxm_tenStocksDSRLFilterConfig;


// filter-configuration must provide operator!=
struct fc_sxm_trStocksDSRLFilterCfg {
    // to check if filter has chanded, configuration has to provice operator!= 
    bool operator!=(fc_sxm_trStocksDSRLFilterCfg const &b) const {
    	(tVoid)b;
        return FALSE;
    }

	fc_sxm_tenStocksDSRLFilterConfig enFilterCfg;
};

#endif //FC_SXM_STOCKS_TYPES_H
