/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_utils.h
* @brief       class for all common util functions across sports service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_SPORTS_UTILS_H_
#define FC_SXM_TCL_SPORTS_UTILS_H_

#include "fc_sxm_tcl_singleton.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "fc_sxm_trace_macros.h"

//Forward Declarations
struct fc_sxm_trSportsList;
struct fc_sxm_trLeagueListData;
class midw_ext_fi_tclString; //to solve prio2 lint info 1730

/*******************************************************************/
/* Class declaration for Utility methods offered by Sports Service
 ******************************************************************/
class fc_sxm_tclSportsUtils :
	public fc_sxm_tclSingleton<fc_sxm_tclSportsUtils>
{
	friend class fc_sxm_tclSingleton<fc_sxm_tclSportsUtils>;

public:
	//TODO: identify other methods which can be made part of this class
	virtual tBool bExtractSportsRow(SXMSportsRow const &row, fc_sxm_trSportsList &sportConfig) const;
	virtual tBool bExtractLeagueRow(SXMSportsRow const &row, fc_sxm_trLeagueListData &league) const;
	virtual tBool bExtractTeamRow(SXMSportsRow const &row, fc_sxm_trTeamInfo &newTeam) const;
	virtual tBool bExtractH2HScheduleRow(SXMSportsRow const &row, fc_sxm_trH2HTable &ScheduleData);
	virtual tBool bExtractNewsRow(SXMSportsRow const &row, string &strNews) const;
	virtual tBool bExtractGolfScheduleRow(SXMSportsRow const &row, fc_sxm_trGolfScheduleTable &ScheduleData);
	virtual tBool bExtractGolfScheduleRankListRow(SXMSportsRow const &row, fc_sxm_trGolfRankList &ScheduleRankListData);
	virtual tBool bExtractMotorRaceScheduleRow(SXMSportsRow const &row, fc_sxm_trMotorRaceScheduleTable &ScheduleData);
	virtual tBool bExtractMotorRaceScheduleRankListRow(SXMSportsRow const &row, fc_sxm_trMotorRaceRankList &ScheduleRankListData);


	//OSAL helper functions
	virtual tVoid vGetOSALDate(tU32 u32tSecs,tChar* chDate,const tChar* chTimeZone,tBool bDSTSetting) const;
	virtual tVoid vGetOSALTime(tU32 u32tSecs,tChar* chDTime,const tChar* chTimeZone,tBool bDSTSetting) const;
	virtual tU32 u32GetLocalTime(tU32 u32tSecs,const tChar* chTimeZone,tBool bDSTSetting) const;
	virtual tU32  u32ComputeHashCode(string* strInput) const;

	virtual tVoid fc_sxm_vString2Fi(tCString sSrcString,  midw_ext_fi_tclString& rffiObj) const;

	virtual ~fc_sxm_tclSportsUtils() { /*Default Destructor*/ }

private:
	fc_sxm_tclSportsUtils();

	virtual tVoid vSetLeagueShortNameAndLevel(fc_sxm_trLeagueListData &league) const;
};



#endif /* FC_SXM_TCL_SPORTS_UTILS_H_ */
