/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_team.h
* @brief       base class for Team based sport types.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_SPORTS_TEAM_H_
#define _FC_SXM_TCL_SPORTS_TEAM_H_

#include "fc_sxm_tcl_sports_base.h"
#include "fc_sxm_tcl_sports_common.h"


struct trCompareSchedules
{
	 bool operator()(const fc_sxm_trH2HTable &trLeftH2HTable, const fc_sxm_trH2HTable &trRightH2HTable)const
	 {
		if(fc_sxm_tclSportsBase::u8GetActiveScheduleType() == FC_SXM_SPORTS_SCHEDULE_RECENT)
			return trLeftH2HTable.u32GameStartTime >= trRightH2HTable.u32GameStartTime;
		else	//For Today & Future
			return trLeftH2HTable.u32GameStartTime <= trRightH2HTable.u32GameStartTime;
	 }
};

/*******************************************************************/
/* Class declaration for TEAM SPORTS
 ******************************************************************/
class fc_sxm_tclTeamSports : public fc_sxm_tclSportsBase
{
protected:
	virtual tBool bIsAllTeamAvailable(tU32 ) const;

public:
	virtual tVoid vGetAllTeams(tU32 , fc_sxm_trAdressing const &) const;
	virtual tVoid vGetTeamSchedules(tU32 u32LeagueID,tU32 u32TeamID,tU8 u8GameType,tU32 u32GameID, fc_sxm_trAdressing const &rAdressing);
	virtual tBool bSetFavoriteTeam(tU32 u32LeagueId,tU32 u32TeamId) const;
	virtual tBool bExtractScheduleRow(tVoid* pHandle, SXMSportsRow &TableRow, tS32 s32TableParam,tU32 u32EpochValue, tBool bIsTeamBased);
	virtual tVoid vEmit(tU32 u32GameID,fc_sxm_trAdressing const &rAdressing);
	virtual tVoid vClearSchedulesList();
	virtual tVoid vGetTopTeams(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing)
	{ /* Implementation to be done */
		//to solve prio2 lint info 715
		(tVoid)u32LeagueID;
		(tVoid)rAdressing;
	}

public:
	virtual ~fc_sxm_tclTeamSports() {  /*Implementation pending*/  }

	fc_sxm_tclTeamSports();
private:
	tBool bIsFavorite(tU32 u32TeamID) const;
	tVoid vRetrieveTeamSchedules(tVoid* pLeagueHandle, tU32 u32TeamID);
	tBool bFilterTeamSchedules(tU32 u32TableIndex) const;
	tVoid vCopySchedulesToFI(midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult &oMRes,tU32 u32TeamID = FC_SXM_TEAM_INVALID_ID) const;
	tVoid vPrintSchedules(midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult &oMResSchedule) const;
	tVoid vEmitTeamSchedules(tU32 u32TeamID,tU32 u32GameID,fc_sxm_trAdressing const &rAdressing);
	tVoid vFillDefaults(midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult &oMResSchedule, tU32 u32GameID,tU32 u32TeamID = FC_SXM_TEAM_INVALID_ID ) const;
	virtual tBool bIsTeamSport() const {return TRUE;}
	tU32 u32GetGameListIndex(tU32 u32GameID) const;
	tVoid vSetTeamSchedAvl(tU32 u32TableIndex);
	tBool bIsGameIDAvailable(tU32 u32GameID) const;

	tVoid vSortTeams(vector< midw_ext_fi_tcl_TeamInfo >& vectTeams) const;
	tVoid vCopyTeamsToFI( const map <tU32, fc_sxm_trTeamInfo>& mapTeams,
			vector< midw_ext_fi_tcl_TeamInfo >& vectTeams) const;
	tVoid vGetFavoritesInLeague(set<tU32>& setFavoriteTeams) const;

private:
	set<fc_sxm_trH2HTable,trCompareSchedules> _setSortedH2HSchedules;
	/* Member variable _u8TeamScheduleAvl is used only for Team based schedules where
	 * 0th bit is set if FC_SXM_SPORTS_SCHEDULE_TODAY games are available,
	 * 1st bit is set if FC_SXM_SPORTS_SCHEDULE_RECENT games are available,
	 * 2nd bit is set if FC_SXM_SPORTS_SCHEDULE_FUTURE gamest are available
	 *
	 * This variable should not be used for League based schedules retrieval
	 */
	tU8 _u8TeamScheduleAvl;
};

#endif  /* _FC_SXM_TCL_SPORTS_TEAM_H_ */
