/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_racing.h
* @brief       Sports motor racing class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_SPORTS_RACING_H_
#define _FC_SXM_TCL_SPORTS_RACING_H_
 
#include "fc_sxm_tcl_sports_common.h"
#ifndef FC_SXM_SPORTS_UTEST
#include "fc_sxm_tcl_sports_nonteam.h"
#include "fc_sxm_tcl_singleton.h"
#else
#include "sports/fc_sxm_tcl_sports_nonteam.h"
//#include "sports/fc_sxm_tcl_singleton.h"
#include "fc_sxm_tcl_singleton.h"
#endif

struct trCompareMotorRaceSchedules
{
	 bool operator()(const fc_sxm_trMotorRaceScheduleTable &trLeftMotorRaceTable, const fc_sxm_trMotorRaceScheduleTable &trRightMotorRaceTable)const
	 {
		 if(fc_sxm_tclSportsBase::u8GetActiveScheduleType() == FC_SXM_SPORTS_SCHEDULE_RECENT)
			 return trLeftMotorRaceTable.u32GameStartTime >= trRightMotorRaceTable.u32GameStartTime;
		 else	//For Today & Future
			 return trLeftMotorRaceTable.u32GameStartTime <= trRightMotorRaceTable.u32GameStartTime;
	 }
};

/*******************************************************************/
/* Class declaration for MOTORSPORTS
 ******************************************************************/
class fc_sxm_tclMotorSport : public fc_sxm_tclNonTeamSports,
						public fc_sxm_tclSingleton<fc_sxm_tclMotorSport>
{
	friend class fc_sxm_tclSingleton<fc_sxm_tclMotorSport>;

public:
	fc_sxm_tclMotorSport ();
	virtual ~fc_sxm_tclMotorSport() { /*Implementation pending*/ }

	virtual tBool bExtractScheduleRow(tVoid* pHandle, SXMSportsRow &TableRow,tS32 s32TableParam,tU32 u32EpochValue, tBool bIsTeamBased);
	virtual tBool bExtractEventRankListRow(SXMSportsRow &TableRow);
	virtual tVoid vClearSchedulesList();
	virtual tVoid vClearEventRankList();
	virtual tU32 u32GetEventListIndex(tU32 u32EventID)const;

private:
	tVoid vCopySchedulesToFI(midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult &oMRes) const;
	tVoid vPrintSchedules(midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult &oMResSchedule) const;
	tVoid vCopyRankListToFI(midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult &oMRes) const;
	tVoid vPrintRankList(midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult &oMResSchedule) const;
	tBool bExtractNestedScheduleRow(ptr pHandle,tU32 u32RankListTableRef,fc_sxm_trMotorRaceScheduleTable &trMotorRaceScheduleTableData) const;
	virtual tU8 u8GetRankedListIndex() const;
	tBool bIsEventIDAvailable(tU32 u32EventID) const;

private:
	set<fc_sxm_trMotorRaceScheduleTable,trCompareMotorRaceSchedules> _setSortedMotorRaceSchedules;
	vector<fc_sxm_trMotorRaceRankList> _vectorMotorRaceRankList;
};

#endif  /* _FC_SXM_TCL_SPORTS_RACING_H_ */
