/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_properties.h
* @brief       file to handle Sports Properties.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_SPORTS_PROPERTIES_H
#define FC_SXM_TCL_SPORTS_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_sports_fi.h"

/*
  Semaphore-protected data of sports-app
*/
struct fc_sxm_tcl_trSportsPropertyServiceDataStatus {
	fc_sxm_tcl_trSportsPropertyServiceDataStatus()
	{ /** Default constructor **/ }

	bool operator!=(fc_sxm_tcl_trSportsPropertyServiceDataStatus const& b) const
	{
		/** Overloaded "!=" operator**/
		return !(oFiMsg==b.oFiMsg);
	}
	midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus oFiMsg;
};

// Added for the Property SportsDataUpdate

struct fc_sxm_tcl_trSportsPropertyDataUpdate {
	fc_sxm_tcl_trSportsPropertyDataUpdate()
		{ /** Default constructor **/ }

	bool operator!=(fc_sxm_tcl_trSportsPropertyDataUpdate const& b) const
	{
	/** Overloaded "!=" operator**/
	return !(oFiMsg==b.oFiMsg);
	}
	midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus oFiMsg;
};
class fc_sxm_tclSportsProperties:
	public fc_sxm_tclSingleton<fc_sxm_tclSportsProperties>
{
	friend class fc_sxm_tclSingleton<fc_sxm_tclSportsProperties>;
public:
	fc_sxm_tclAutoProperty<fc_sxm_tcl_trSportsPropertyServiceDataStatus,
		CCA_C_U16_SRV_SXM_SPORTS, /*the service-id of the CCA-Service */
		MIDW_EXT_SXM_SPORTSFI_C_U16_SPORTSSERVICEDATASTATUS /* give FID if notification to service is needed  */
			> oSportsServiceDataStatus;

	fc_sxm_tclAutoProperty<fc_sxm_tcl_trSportsPropertyDataUpdate,
		CCA_C_U16_SRV_SXM_SPORTS, /*the service-id of the CCA-Service */
		MIDW_EXT_SXM_SPORTSFI_C_U16_SPORTSDATAUPDATE /* give FID if notification to service is needed  */
		> oSportsDataUpdateStatus;
};

#endif
