/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_nonteam.cpp
* @brief       base class for Non-Team Sport types.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_tcl_sports_nonteam.h"
#include "fc_sxm_tcl_sports_app_interface.h"
#include "fc_sxm_tcl_sports_utils.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "fc_sxm_trace_macros.h"
 
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_SPORTS_NONTEAMSPORTS
#include "trcGenProj/Header/fc_sxm_tcl_sports_nonteam.cpp.trc.h"
#endif

fc_sxm_tclNonTeamSports::fc_sxm_tclNonTeamSports()
{
	// Default constructor
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports CTOR"));
}
/*
 * Method returns the Rank List for a particular Schedule selected from User for the specific Non Team/Event Sport ID
 */
tVoid fc_sxm_tclNonTeamSports::vGetEventRankList(tU32 u32LeagueID, tU8 u8EventType, tS32 s32TableParam, tS32 s32TableRef, fc_sxm_trAdressing const &rAdressing)
{
	ETG_TRACE_USR4(("fc_sxm_tclGolf::vGetRankedList Entered u32LeagueID=%u,u8EventType=%u,s32ParamIndex=%d, s32TableRef=%d",u32LeagueID,u8EventType,s32TableParam, s32TableRef));
	tU32  u32RootLeagueID,u32SubLeagueID;
	tBool bSubLeague = !bIsRootAffiliate(u32LeagueID);
	if(bSubLeague) // For Sub Leagues
	{
		u32RootLeagueID  = u32GetRootAffiliate(u32LeagueID);
		u32SubLeagueID	= u32LeagueID;
	}
	else // For Root Affiliate
	{
		u32RootLeagueID = u32LeagueID;
		u32SubLeagueID = AFFILIATE_INVALID_ID;
	}

	// Clear the Rank List vector
	vClearEventRankList();

	//Filter and Retrieve Schedule's Rank list  for Root
	vRetriveEventRankList(u32RootLeagueID, u32SubLeagueID, bSubLeague, u8EventType, s32TableParam, s32TableRef);

	//Finally Send Method Result to HMI
	vEmitRankList(rAdressing);

	ETG_TRACE_USR4(("fc_sxm_tclSportsBase::vGetSchedules Exit"));

}

/*
 * Method returns the Rank List for a particular Schedule selected for Non Team Sport
 */

tVoid fc_sxm_tclNonTeamSports::vRetriveEventRankList(tU32 u32RootLeagueID, tU32 u32SubLeagueID , tBool bForSubLeague ,tU8 u8EventType, tS32 s32TableParam, tS32 s32TableRef)
{
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vRetriveEventRankList Entered u32RootLeagueID=%u,u32SubLeagueID=%u,bForSubLeague=%d,u8EventType=%u,s32TableParam=%d, s32TableRef = %d",
			u32RootLeagueID,u32SubLeagueID,bForSubLeague,u8EventType,s32TableParam, s32TableRef));

	//Set Current Active LEague
	fc_sxm_tclSportsBase::_u32ActiveLeague = bForSubLeague ? u32SubLeagueID : u32RootLeagueID;

	//Check if the league exists
	SXM_IF_FIND_MAP(tU32, fc_sxm_trLeagueData, cit, _mapLeagueDetails,u32RootLeagueID)
	{
		SXM_FOREACH_CONST( set<tS32>, cSetIt, cit->second.setLeagueTableParam)
		{
			//Check for the requested Table Param to get the rank list
			if (s32TableParam == *cSetIt)
			{
				vExtractEventRankList(cit->second.poLeagueHandle,s32TableParam, s32TableRef);
			}
		}
	}
	else
	{
		ETG_TRACE_ERR(("fc_sxm_tclNonTeamSports::vRetriveEventRankList::Not found a League=%d",u32SubLeagueID));
	}

	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vRetriveEventRankList exited.."));
}

tVoid fc_sxm_tclNonTeamSports::vExtractEventRankList(tVoid* pLeagueHandle, tS32 s32TableParam, tS32 s32TableRef)
{
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vExtractEventRankList SXM_sports_begin Handle = %x, s32TableParam = %d, s32TableRef = %d",
			pLeagueHandle,s32TableParam, s32TableRef));

	ptr ext = OSAL_NULL;
	ptr ext2 = OSAL_NULL;
	SXMSportsRow row,row2,header;
	sxm_result_code enRetCode;

	if ((enRetCode = (sxm_result_code) sxm_sports_begin(pLeagueHandle, SXM_SPORTS_TABLE, s32TableParam , &ext, &header)) == SXM_E_OK)
	{
		tU8 u8RankListIndex  = u8GetRankedListIndex();
		while ((enRetCode = (sxm_result_code) sxm_sports_extract_row(ext, &row)) == SXM_E_OK)
		{
			if((row.present & (1<<u8RankListIndex)) &&
					(row.value[u8RankListIndex] == s32TableRef))
			{
				if ((enRetCode = (sxm_result_code) sxm_sports_begin_nested(ext, SXM_SPORTS_TABLE, s32TableRef, &ext2, &row2)) == SXM_E_OK)
				{
					// Iterate until all rows are read.
					while((enRetCode = (sxm_result_code) sxm_sports_extract_row(ext2, &row2)) == SXM_E_OK)
					{
						//The sxm_sports_extract_row routine returns the data for the event rank list as a row in the table SXM_SPORTS_TABLE.
						//Each league would be reported in one row.
						(tVoid) bExtractEventRankListRow(row2);
					} //end while loop
					(tVoid) sxm_sports_end(ext2);
					break;

				}//end if sxm_sports_nested_begin loop
				else
				{
					ETG_TRACE_ERR(("sxm_sports_begin_nested failed at fc_sxm_tclNonTeamSports::vExtractEventRankList\t enRetCode = %u",enRetCode));
				}
			}
			else
			{
				ETG_TRACE_USR4(("Rank List is not available for selected Event"));
			}
		}
		(tVoid) sxm_sports_end(ext);
	}
	else
	{
		ETG_TRACE_ERR(("sxm_sports_begin failed at fc_sxm_tclNonTeamSports::vExtractEventRankList\t enRetCode = %u",enRetCode));
	}
}
/*
 * Method to send Method Result to HMI
 */
tVoid fc_sxm_tclNonTeamSports::vEmit(tU32 u32GameID,fc_sxm_trAdressing const &rAdressing)
{
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vEmit Entered"));
	SXM_ASSERT_RETURN(OSAL_NULL != _poApp)

	//Get instance for Utils
	fc_sxm_tclSportsUtils* poUtils = fc_sxm_tclSportsUtils::instance();
	SXM_ASSERT_RETURN( OSAL_NULL!= poUtils)

	midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult oMResSchedule;
	oMResSchedule.ScheduledEvents.SPORT_ID =  _u8SPID ;
	//oMResSchedule.ScheduledEvents.AFFILIATE_ID = fc_sxm_tclSportsBase::_u32ActiveLeague;

	// Check whether the active League is the Root Affiliate ID or Sub Affiliate ID and based on that fetch the InSeason Info
	if(bIsRootAffiliate(fc_sxm_tclSportsBase::_u32ActiveLeague)) // For Root Affiliate
	{
		SXM_IF_FIND_MAP_CONST(tU32, fc_sxm_trLeagueListData, cMapIt, _mapLeague, fc_sxm_tclSportsBase::_u32ActiveLeague)
		{
			oMResSchedule.ScheduledEvents.AFFILIATE_INFO.AFFILIATE_ID = cMapIt->second.u32AfID;
			// Affiliate Name is filled here but this info is not required by HMI
			poUtils->fc_sxm_vString2Fi(((cMapIt->second.strAflSName).c_str()),oMResSchedule.ScheduledEvents.AFFILIATE_INFO.AffiliateName);
			oMResSchedule.ScheduledEvents.AFFILIATE_INFO.InSeason = cMapIt->second.bInSeason;
		}
	}
	else // For Sub Root Affiliate
	{
		//tU32 u32RootLeagueID = u32GetRootAffiliate(fc_sxm_tclSportsBase::_u32ActiveLeague);
		fc_sxm_trLeagueListData trLeagueListData;
		vGetLeagueData(fc_sxm_tclSportsBase::_u32ActiveLeague,trLeagueListData);

		oMResSchedule.ScheduledEvents.AFFILIATE_INFO.AFFILIATE_ID = trLeagueListData.u32AfID;
		// Affiliate Name is filled here but this info is not required by HMI
		poUtils->fc_sxm_vString2Fi(((trLeagueListData.strAflSName).c_str()),oMResSchedule.ScheduledEvents.AFFILIATE_INFO.AffiliateName);
		oMResSchedule.ScheduledEvents.AFFILIATE_INFO.InSeason = trLeagueListData.bInSeason;
	}

	//Print Affiliate Info
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vFillDefaults: League Name %s",oMResSchedule.ScheduledEvents.AFFILIATE_INFO.AffiliateName.szValue));
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vFillDefaults: League ID %d",oMResSchedule.ScheduledEvents.AFFILIATE_INFO.AFFILIATE_ID));
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vFillDefaults: League Season %d",oMResSchedule.ScheduledEvents.AFFILIATE_INFO.InSeason));

	oMResSchedule.ScheduledEvents.bIsRecentEventsAvl = bIsScheduleAvilable(fc_sxm_tclSportsBase::_u32ActiveLeague, FC_SXM_SPORTS_SCHEDULE_RECENT);
	oMResSchedule.ScheduledEvents.bIsCurrentEventsAvl = bIsScheduleAvilable(fc_sxm_tclSportsBase::_u32ActiveLeague, FC_SXM_SPORTS_SCHEDULE_TODAY);
	oMResSchedule.ScheduledEvents.bIsFutureEventsAvl = bIsScheduleAvilable(fc_sxm_tclSportsBase::_u32ActiveLeague, FC_SXM_SPORTS_SCHEDULE_FUTURE);
	oMResSchedule.ScheduledEvents.ListIndex = u32GetEventListIndex(u32GameID); // zero based List Index Passed to HMI
	oMResSchedule.ScheduledEvents.EventType.enType = (midw_ext_fi_tcl_GameType::tenType)fc_sxm_tclSportsBase::_u8ScheduleType;

	ETG_TRACE_USR4(("Sport Team_ID=%u\t ListIndex =%u EventType = %u ",oMResSchedule.ScheduledEvents.SPORT_ID, oMResSchedule.ScheduledEvents.ListIndex,oMResSchedule.ScheduledEvents.EventType.enType ));
	ETG_TRACE_USR4(("bIsRecentGamesAvl = %u\tbIsCurrentGamesAvl = %u\tbIsFutureGamesAvl = %u",
				oMResSchedule.ScheduledEvents.bIsRecentEventsAvl, oMResSchedule.ScheduledEvents.bIsCurrentEventsAvl, oMResSchedule.ScheduledEvents.bIsFutureEventsAvl));

	//Copy Internal Schedules Data to FI
	vCopySchedulesToFI(oMResSchedule);

	//Print Schedules
	vPrintSchedules(oMResSchedule);

	// Send FI message
	_poApp->vSendFiMsg(rAdressing, oMResSchedule);
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vEmit Exited"));
}

/*
 * Method to send MEthod Result to HMI
 */
tVoid fc_sxm_tclNonTeamSports::vEmitRankList(fc_sxm_trAdressing const &rAdressing)
{
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vEmit Entered"));
	SXM_ASSERT_RETURN(OSAL_NULL != _poApp)

	midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult oMResSchedule;

	oMResSchedule.EventInfo.SPORT_ID =  _u8SPID ;
	oMResSchedule.EventInfo.AFFILIATE_ID = fc_sxm_tclSportsBase::_u32ActiveLeague;

	ETG_TRACE_USR4(("Sport Team_ID=%d",oMResSchedule.EventInfo.SPORT_ID));
	ETG_TRACE_USR4(("AFFILIATE_ID=%d",oMResSchedule.EventInfo.AFFILIATE_ID));

	//Copy Internal Schedules Data to FI
	vCopyRankListToFI(oMResSchedule);

	//Print Schedules
	vPrintRankList(oMResSchedule);

	// Send FI message
	_poApp->vSendFiMsg(rAdressing, oMResSchedule);
	ETG_TRACE_USR4(("fc_sxm_tclNonTeamSports::vEmit Exited"));
}
