/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_config.h
* @brief       File lets the developer configure at compile time the list of sports items needed
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_SPORTS_CONFIG_H_
#define FC_SXM_TCL_SPORTS_CONFIG_H_

/*
 * The pre-processor MACROS defined here utilized by class sports_factory during creation of
 * different sports objects.
 *
 * If a sport needs to be disabled from being shown to the user, the corresponding sport item needs
 * to be disabled from the below list and project needs to be recompiled
 */
//#define FC_SXM_ENABLE_SPORT_AGGREGATE //Enable Aggregate
#define FC_SXM_ENABLE_SPORT_FOOTBALL //Enable Football
#define FC_SXM_ENABLE_SPORT_BASEBALL //Enable Baseball
#define FC_SXM_ENABLE_SPORT_BASKETBALL //Enable Basketball
#define FC_SXM_ENABLE_SPORT_ICEHOCKEY //Enable IceHockey
#define FC_SXM_ENABLE_SPORT_MOTORSPORT //Enable Motorsport
#define FC_SXM_ENABLE_SPORT_GOLF //Enable Golf
#define FC_SXM_ENABLE_SPORT_SOCCER //Enable Soccer
//#define FC_SXM_ENABLE_SPORT_TENNIS //Enable Tennis


#endif /* FC_SXM_TCL_SPORTS_CONFIG_H_ */
