/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_common.h
* @brief        Sports common declarations that would be used across whole of sports service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_SPORTS_COMMON_H_
#define FC_SXM_TCL_SPORTS_COMMON_H_

#if 0
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif 

#include "fc_sxm_types.h"

//struct to hold SMSe Data
struct fc_sxm_trLeagueData
{
	tVoid* poLeagueHandle;
	tU32 u32LeagueStatus;
	set<tS32> setLeagueTableParam;
	fc_sxm_trLeagueData():
		poLeagueHandle(OSAL_NULL),
		u32LeagueStatus(0)
	{
		setLeagueTableParam.clear();
	}
};

//Struct to hold temp SMSe Callback Data
struct fc_sxmtrSMSeCallbackData
{
	tU8 u8SportID;
	tU32 u32LeagueID;
	tVoid* poLeagueHandle;
	tInt intUpdateType;
	tInt intTableParam;
};

//Macros for SMSe Schedule date values
#define FC_SXM_SPORTS_SCHEDULE_SMSE_LAST 0
#define FC_SXM_SPORTS_SCHEDULE_SMSE_TODAY 8
#define FC_SXM_SPORTS_SCHEDULE_SMSE_NEXT 16
#define FC_SXM_SPORTS_TABLE_SMSE_NEWS 17

//Macros for HMI Schedule Game Types
#define FC_SXM_SPORTS_SCHEDULE_TODAY 0
#define FC_SXM_SPORTS_SCHEDULE_RECENT 1
#define FC_SXM_SPORTS_SCHEDULE_FUTURE 2
#define FC_SXM_SPORTS_NEWS 3

//Macros for INvalid ID's
#define FC_SXM_TEAM_INVALID_ID 0xffffffff

#define AFFILIATE_INVALID_ID 0xffff
#define SCHEDULE_INVALID_ID 255

#define FC_SXM_SPORTS_DATA_NOT_APPLICABLE 2

#define SPORTS_MAX_DATE_FORMAT_LEN 20

#define FC_SXM_SPORTS_HMI_AFF_FIXED_LIST_START 0
#define FC_SXM_SPORTS_HMI_AFF_FIXED_LIST_END 5
#define DEFAULT_GAME_EVENT_ID  0xFFFFFFFF

#define SXM_SPORTS_PARSE_ROW_RETURN_VAL(row,  data, NoOfHeaders, retVal)     \
	for (tU8 u8Header = 0u; u8Header < NoOfHeaders; ++u8Header )	\
	{																\
		tU32 u32Value = 0u;											\
		string strValue("");										\
		if ( row.present & (1u << u8Header))						\
		{															\
			if ( row.types & (1u << u8Header))						\
			{														\
				strValue = row.buffer+row.value[u8Header] ;			\
			}														\
			else													\
			{														\
				u32Value = (tU32) row.value[u8Header] ;				\
			}														\
			retVal = TRUE;											\
		}															\
		(data.*funcPtrArray[u8Header])(u32Value, strValue);			\
	}

typedef enum
{
	//The different states for the League Requests issued
	fc_sxm_tenLeagueReqState_Initial = 0,
	fc_sxm_tenLeagueReqState_Requested = 1,
	fc_sxm_tenLeagueReqState_Updated = 2,
	fc_sxm_tenLeagueReqState_Closed = 3,
	fc_sxm_tenLeagueReqState_ReIssued = 4,
	fc_sxm_tenLeagueReqState_Unavailable = 5
} fc_sxm_tenLeagueReqState;


typedef enum
{
	// sport ID's specific for each sport. These are the values currently broadcasted by SMSe.
	// SXm have assured that the mapping between sport IDs and sport Names wont change in future.
	fc_sxm_tenSportID_Aggregate = 0,
	fc_sxm_tenSportID_Football = 1,
	fc_sxm_tenSportID_Baseball = 2,
	fc_sxm_tenSportID_Basketball = 3,
	fc_sxm_tenSportID_IceHockey = 4,
	fc_sxm_tenSportID_MotorSport = 5,
	fc_sxm_tenSportID_Golf = 6,
	fc_sxm_tenSportID_Soccer = 7,
	fc_sxm_tenSportID_Tennis = 8,
	fc_sxm_tenSportID_Unknown = 9
} fc_sxm_tenSportID;

//SMSe Table Mapping for SportList
struct fc_sxm_trSportsList {
	tU8 u8SportID;
	string strSportName;

public:
	fc_sxm_trSportsList(string strNUll = ""):u8SportID(0u), strSportName(strNUll) { /*Default CTOR*/ }

	inline tVoid vSetSportID(tU32 u32ID, string &/*strName*/) {
		//Method sets only the sportID
		u8SportID = (tU8) u32ID;
	}

	inline tVoid vSetSportName(tU32 /*u32ID*/, string &strName) {
		//Method sets only the sportName
		strSportName = strName;
	}
	virtual ~fc_sxm_trSportsList(){}
};

struct fc_sxm_trTeamInfo;

//SMSe Table Mapping for League List
struct fc_sxm_trLeagueListData :public fc_sxm_trSportsList
{
	tU32 u32AfID;
	string strAfName;
	tU32 u32GDRef;
	tBool bInSeason;
	string strAflLName;
	string strAflSName;

	//Variable stores if Tree Value is available for the given league and
	//based on bTreeAvl's status, method result can be sent back to HMI
	//tBool bTreeAvl;
	fc_sxm_tenLeagueReqState enRequestState;

	//Stores level from Root Affiliate; For Root Affiliate, level = 0,
	//If affiliate name is "NHL:Eastern Conference:Atlantic Division", then NHL is the Root Affiliate with level = 0,
	//Eastern Conference = level 1 and Atlantic Division = level 2
	tU8 u8Level;

	//Stores set of all children, grand children, great grand children, etc's LeagueIDs,
	set<tU32> setFamily;

	//Map of all Sub-leagues affiliated to a League
	map <tU32, fc_sxm_trLeagueListData> mapSubLeagues;

	//Map of all teams affiliated to a league
	map <tU32, fc_sxm_trTeamInfo> mapTeams;

public:
	fc_sxm_trLeagueListData(string strNUll = ""):u32AfID(0u), strAfName(strNUll), u32GDRef(0u),
			bInSeason(FALSE), strAflLName(strNUll), strAflSName(strNUll), enRequestState(fc_sxm_tenLeagueReqState_Initial) /*bTreeAvl(FALSE)*/, u8Level(0u) { /* Default CTOR */
		setFamily.clear();
		mapSubLeagues.clear();
		mapTeams.clear();
	}

	inline tVoid vSetAffiliateID(tU32 u32ID, string &/*strName*/) {
		// Method sets only the Affiliate ID
		u32AfID = u32ID;
	}

	inline tVoid vSetAffiliateName(tU32 /*u32ID*/, string &strName) {
		// Method sets only the Affiliate Name
		strAfName = strName;
	}

	inline tVoid vSetGDRef(tU32 u32ID, string &/*strName*/) {
		// Method sets only the GDRef key
		u32GDRef = u32ID;
	}

	inline tVoid vSetInSeason(tU32 u32ID, string &/*strName*/) {
		// Method sets only the In Season status
		bInSeason = (tBool) u32ID;
	}

	inline tVoid vSetAffiliateLongName(tU32 /*u32ID*/, string &strName) {
		// Method sets only the Affiliate's long name
		strAflLName = strName;
	}

	inline tVoid vSetAffiliateShortName(tU32 /*u32ID*/, string &strName) {
		// Method sets only the Affiliate's short name
		strAflSName = strName;
	}

	inline tVoid vResetLeagueTree() {
		// Method resets the previously built LeagueTree.
		setFamily.clear();
		mapSubLeagues.clear();
		mapTeams.clear();
		//bTreeAvl = FALSE;
		enRequestState = fc_sxm_tenLeagueReqState_Initial;
	}
};

//Struct for sendin msgs thru cca service
struct fc_sxm_trLeagueInfo {
	tU32 u32LeagueID;
	tU32 u32LeagueName;
};

struct fc_sxm_trTeamInfo {
	tU32 u32TeamID; //Team Identifier
	string strAbbr; // Abbreviated team name
	string strTeamName; // Team Name
	string strNickName; //Team Nick name

public:
	fc_sxm_trTeamInfo(tU32 u32ID = 0u, string sAbbr = "", string sTeamName = "", string sNickName = ""):
		u32TeamID(u32ID), strAbbr (sAbbr), strTeamName (sTeamName), strNickName (sNickName) { /*Default CTOR*/ }

	inline tVoid vSetTeamID(tU32 u32ID, string &/*strName*/) {
		//Method sets only the team ID
		u32TeamID = u32ID;
	}

	inline tVoid vSetAbbreviatedName(tU32 /*u32ID*/, string &strName) {
		// Method sets only the Abbreviated team name
		strAbbr = strName;
	}

	inline tVoid vSetTeamName(tU32 /*u32ID*/, string &strName) {
		// Method sets only the Team name
		strTeamName = strName;
	}

	inline tVoid vSetNickName(tU32 /*u32ID*/, string &strName) {
		// Method sets only the Team Nick name
		strNickName = strName;
	}

};

//SMSe Table Mapping for League List
struct fc_sxm_trH2HTable
{
	//Home Team Description Values
	tU32 u32HomeTeamID;
	string strHomeTeamAbr;
	string strHomeTeamNick;
	string strHomeTeamFull;

	//Visit Team Description Values
	tU32 u32VisitTeamID;
	string strVisitTeamAbr;
	string strVisitTeamNick;
	string strVisitTeamFull;

	//Game Description Values
	tU32 u32GameStatus;
	string strGameDivision;
	tU32 u32GameStartTime;

	//Score Description Values
	tU32 u32HomeTeamScore;
	tU32 u32VisitTeamScore;
	tU32 u32WinnerTeam;

	//XM Channel Description Values
	tU32 u32HomeChan;
	tU32 u32VisitChan;
	tU32 u32NatChan;

	//Others
	tU32 u32GameClock;
	tU32 u32TableINdex;
	tU32 u32TableAge;
	tU32 u32GameID; // Unique Game ID Generated for each Game

public:
	fc_sxm_trH2HTable(string strNUll = ""):
		u32HomeTeamID(0u), strHomeTeamAbr(strNUll), strHomeTeamNick(strNUll),strHomeTeamFull(strNUll),
		u32VisitTeamID(0u), strVisitTeamAbr(strNUll), strVisitTeamNick(strNUll),strVisitTeamFull(strNUll),
		u32GameStatus(0u), strGameDivision(strNUll),u32GameStartTime(0u),
		u32HomeTeamScore(0u),u32VisitTeamScore(0u),u32WinnerTeam(0u),
		u32HomeChan(0u),u32VisitChan(0u),u32NatChan(0u),
		u32GameClock(0u),u32TableINdex(0u),u32TableAge(0u),u32GameID(0u){ /* Default CTOR */ }

	//HOme Team Details
	inline tVoid vSetHomeTeamID(tU32 u32ID, string &/*strName*/) {
		// Method sets only the HomeTeamID
		u32HomeTeamID = u32ID;
	}
	inline tVoid vSetHomeTeamAbr(tU32 /*u32ID*/, string &strName) {
		// Method sets only the HomeTeamAbr Name
		strHomeTeamAbr = strName;
	}
	inline tVoid vSetHomeTeamNick(tU32 /*u32ID*/, string &strName) {
		// Method sets only the HomeTeamAbr Name
		strHomeTeamNick = strName;
	}
	inline tVoid vSetHomeTeamFull(tU32 /*u32ID*/, string &strName) {
		// Method sets only the HomeTeamAbr Name
		strHomeTeamFull = strName;
	}

	//Visiting Team Details
	inline tVoid vSetVisitTeamID(tU32 u32ID, string &/*strName*/) {
		// Method sets only the VisitTeamID
		u32VisitTeamID = u32ID;
	}
	inline tVoid vSetVisitTeamAbr(tU32 /*u32ID*/, string &strName) {
		// Method sets only the VisitTeamAbr Name
		strVisitTeamAbr = strName;
	}
	inline tVoid vSetVisitTeamNick(tU32 /*u32ID*/, string &strName) {
		// Method sets only the VisitTeamNick Name
		strVisitTeamNick = strName;
	}
	inline tVoid vSetVisitTeamFull(tU32 /*u32ID*/, string &strName) {
		// Method sets only the VisitTeamFull Name
		strVisitTeamFull = strName;
	}

	//Game Details
	inline tVoid vSetGameStatus(tU32 u32Val, string &/*strName*/) {
		u32GameStatus = u32Val;
	}
	inline tVoid vSetGameDivision(tU32 /*u32ID*/, string &strName) {
		strGameDivision = strName;
	}
	inline tVoid vSetGameStartTime(tU32 u32Val, string &/*strName*/) {
		u32GameStartTime = u32Val;
	}

	//Score Details
	inline tVoid vSetHomeTeamScore(tU32 u32Val, string &/*strName*/) {
		u32HomeTeamScore = u32Val;
	}
	inline tVoid vSetVisitTeamScore(tU32 u32Val, string &/*strName*/) {
		u32VisitTeamScore = u32Val;
	}
	inline tVoid vSetWinnerTeam(tU32 u32Val, string &/*strName*/) {
		u32WinnerTeam = u32Val;
	}

	//Audio or Channel Information
	inline tVoid vSetHomeChan(tU32 u32Val, string &/*strName*/) {
		u32HomeChan = u32Val;
	}
	inline tVoid vSetVisitChan(tU32 u32Val, string &/*strName*/) {
		u32VisitChan = u32Val;
	}
	inline tVoid vSetNatChan(tU32 u32Val, string &/*strName*/) {
		u32NatChan = u32Val;
	}

	//Others
	inline tVoid vSetGameClock(tU32 u32Val, string &/*strName*/) {
		u32GameClock = u32Val;
	}
	inline tVoid vSetTableINdex(tU32 u32Val, string &/*strName*/) {
		u32TableINdex = u32Val;
	}
	inline tVoid vSetTableAge(tU32 u32Val, string &/*strName*/) {
		u32TableAge = u32Val;
	}

};


//SMSe Table for Golf Rank List

struct fc_sxm_trGolfRankList
{
	string strRank;
	string strGolfer;
	string strScore;

public :
	fc_sxm_trGolfRankList(string strNUll = ""):
	 strRank(strNUll), strGolfer(strNUll),strScore(strNUll){ /* Default CTOR */ };

	inline tVoid vSetGolferRank(tU32 /*u32Val*/, string &strName) {
		strRank = strName;
	}
	inline tVoid vSetGolferName(tU32 /*u32Val*/, string &strName) {
		strGolfer = strName;
	}
	inline tVoid vSetGolferScore(tU32 /*u32Val*/, string &strName) {
		strScore = strName;
	}
};

//SMSe Table Mapping for Golf Schedule
struct fc_sxm_trGolfScheduleTable
{
	// SMSe Golf Schedule Table Contents from sxm_sports_begin
	tU32 u32EventState;
	tU32 u32RankListTableRef;
	string strTourneyTitle;
	string strCourseName;
	tU32 u32CourseYardage;
	tU32 u32Purse;

	// SMSe Nested Table Info for Golf 
	fc_sxm_trGolfRankList trGolfRankList;

	// other HMI required data below
	tBool bIsRankAvailable;
	tU32 u32Epoch;// Value from header to get the epoch(sec)
	tS32 s32TableParam; // Table param updated from SMSe callback request
	tU32 u32EventID; // Unique Event ID Generated for each event

	bool operator==(const fc_sxm_trGolfScheduleTable& rhs) const
	{
		return s32TableParam == rhs.s32TableParam;
	}

public:
	fc_sxm_trGolfScheduleTable(string strNUll = ""):
		u32EventState(0u), u32RankListTableRef(0u), strTourneyTitle(strNUll),strCourseName(strNUll),
		u32CourseYardage(0u), u32Purse(0u), bIsRankAvailable(false),
		u32Epoch(0u), s32TableParam(0),u32EventID(0u)
			{ /* Default CTOR */ };

    inline tVoid vSetEventState(tU32 u32Val, string &/*strName*/) {
    	u32EventState = u32Val;
    }

	inline tVoid vSetRankTableRef(tU32 u32Val, string &/*strName*/) {
		u32RankListTableRef = u32Val;
	}

	inline tVoid vSetTourneyTitle(tU32 /*u32Val*/, string &strName) {
		strTourneyTitle = strName;
	}

	inline tVoid vSetCourseName(tU32 /*u32Val*/, string &strName) {
		strCourseName = strName;
	}

	inline tVoid vSetYardage(tU32 u32Val, string &/*strName*/) {
		u32CourseYardage = u32Val;
	}

	inline tVoid vSetPurse(tU32 u32Val, string &/*strName*/) {
		u32Purse = u32Val;
	}

};

//SMSe Table for Motor Race Rank List

struct fc_sxm_trMotorRaceRankList
{
	string strRank;
	string strDriverName;
	tU32 tu32LeaderLaps;
	string strCarNumber;
	string strCarMake;

public :
	fc_sxm_trMotorRaceRankList(string strNUll = ""):
		 strRank(strNUll),strDriverName(strNUll),
		 tu32LeaderLaps(0xFFFF), strCarNumber(strNUll), strCarMake((strNUll))
		{ /* Default CTOR */ };

	inline tVoid vSetRank(tU32 /*u32Val*/, string &strName) {
		strRank = strName;
	}

	inline tVoid vSetName(tU32 /*u32Val*/, string &strName) {
		strDriverName = strName;
	}

	inline tVoid vSetLeaderLapsCount(tU32 u32Val, string &/*strName*/) {
		tu32LeaderLaps = u32Val;
	}

	inline tVoid vSetCarNumber(tU32 /*u32Val*/, string &strName) {
		strCarNumber = strName;
	}

	inline tVoid vSetCarMake(tU32 /*u32Val*/, string &strName) {
		strCarMake = strName;
	}

};

//SMSe Table Mapping for Golf Schedule
struct fc_sxm_trMotorRaceScheduleTable
{
	// Motor Race Schedule Table Contents from sxm_sports_begin
	tU32 u32EventState;
	tU32 u32GameStartTime;
	tU32 u32RankListTableRef;
	string strRaceName;
	string strTrackName;
	tU32 u32RaceLaps;
	string strWinnerName;
	tU32 u32NatChan;

	// Motor Race Event Rank List Contents from sxm_sports_nested_begin

	fc_sxm_trMotorRaceRankList trMotorRaceRankList;

	// other HMI required data below
	tS32 s32TableParam;// Table Param updated from SMSe callback request
	tBool bIsRankAvailable;
	tU32 u32EventID; // Unique Event ID Generated for each event

	bool operator==(const fc_sxm_trMotorRaceScheduleTable& rhs) const
	{
	    return s32TableParam == rhs.s32TableParam;
	}

public:
	fc_sxm_trMotorRaceScheduleTable(string strNUll = ""):
		u32EventState(0u), u32GameStartTime(0u), u32RankListTableRef(0u),strRaceName(strNUll),strTrackName(strNUll),
		u32RaceLaps(0u), strWinnerName(strNUll),u32NatChan(0u),s32TableParam(0u),bIsRankAvailable(FALSE),u32EventID(0u){ /* Default CTOR */ };

    inline tVoid vSetEventState(tU32 u32Val, string &/*strName*/) {
    	u32EventState = u32Val;
    }

    inline tVoid vSetGameStartTime(tU32 u32Val, string &/*strName*/) {
    		u32GameStartTime = u32Val;
    }

	inline tVoid vSetRankTableRef(tU32 u32Val, string &/*strName*/) {
		u32RankListTableRef = u32Val;
	}

	inline tVoid vSetRaceName(tU32 /*u32Val*/, string &strName) {
		strRaceName = strName;
	}

	inline tVoid vSetTrackName(tU32 /*u32Val*/, string &strName) {
		strTrackName = strName;
	}

	inline tVoid vSetCompleteRaceLaps(tU32 u32Val, string &/*strName*/) {
		u32RaceLaps = u32Val;
	}

	inline tVoid vSetWinnerName(tU32 /*u32Val*/, string &strName) {
		strWinnerName = strName;
	}

	inline tVoid vSetNatChan(tU32 u32Val, string &/*strName*/) {
		u32NatChan = u32Val;
	}

};



#endif /* FC_SXM_TCL_SPORTS_COMMON_H_ */

