/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_base_interface.h
* @brief       Sports Base interface class
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_SPORTS_BASE_INTERFACE_H_
#define _FC_SXM_TCL_SPORTS_BASE_INTERFACE_H_

#include "fc_sxm_tcl_sports_fi_msgs.h"
#include "fc_sxm_smse.h"

class fc_sxm_tclSportsAppIFace;

/*
 * Base class interface for sports base objects
 */
class fc_sxm_tclISportsBase
{
public:
	virtual tVoid vInitSport(tU8 u8ID, tCString strName) = 0;
	virtual tVoid vSetObserver(fc_sxm_tclSportsAppIFace *) = 0;
	virtual tVoid vGetLeagueTree(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing) = 0;
	virtual tVoid vGetAllTeams(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing) const = 0;
	virtual tVoid vGetTeamSchedules(tU32 u32LeagueID,tU32 u32TeamID,tU8 u8GameType, tU32 u32GameID,fc_sxm_trAdressing const &rAdressing) = 0;
	virtual tVoid vGetSchedules(tU32 u32LeagueID,tU8 u8GameType,  tU32 u32GameID,fc_sxm_trAdressing const &rAdressing)= 0;
	virtual tVoid vGetEventRankList(tU32 u32LeagueID, tU8 u8GameType, tS32 s32ParamIndex, tS32 s32TableRef, fc_sxm_trAdressing const &rAdressing)= 0;
	virtual tVoid vGetTopTeams(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing) = 0;
	virtual tBool bSetFavoriteTeam(tU32 u32LeagueId,tU32 u32TeamId) const = 0;

	virtual tVoid vPrintSportsDetails() const = 0;
	virtual tVoid vPrintLeagues() const = 0;
	virtual tVoid vBuildLeagueList(fc_sxm_trLeagueListData& league) = 0;
	virtual tU8 u8GetSportID() const = 0;
	virtual tCString sGetSportName() const = 0;
	virtual tVoid vHandleLeagueUpdates(fc_sxm_trMsgSportsSMSeLeagueCallback const *prMsg) = 0;
	virtual tVoid vGetNewsItems(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing) = 0;

	//cca-messages
	virtual tVoid vSendLeagueInfo(fc_sxm_trAdressing const &rAdressing) const = 0;
	virtual tVoid vStoreLeagueInfo(tVoid) const = 0;
	virtual tVoid vCreateLeagueRequest(tU32 u32LeagueID) = 0;
	virtual tU32 u32GetRootAffiliate(tU32 u32SubLeague) const = 0;
	virtual tVoid vRemoveLeagueRequests(tVoid) = 0;
	virtual tBool bIsRootAffiliate(tU32 u32LeagueID) const = 0;
	virtual tVoid vNotifySportDataUpdate(tU32 u32TableLeague,tU8 u8UpdateType) = 0;
	virtual tVoid vNotifyLeagueUpdates(tVoid) = 0;

	virtual tVoid vIgnoreUpdates(tBool bIgnore) = 0;
	virtual tVoid vSetCBAddress(tU32 u32LeagueID, fc_sxm_trAdressing const &rAddr) const = 0;
	virtual tVoid vResetLeagues() = 0;
	virtual ~fc_sxm_tclISportsBase() { }
};

#endif  /* _FC_SXM_TCL_SPORTS_BASE_INTERFACE_H_ */
