/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_app.h
* @brief       Sports application handler
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_SPORTS_APP_H_
#define _FC_SXM_TCL_SPORTS_APP_H_

#include "fc_sxm_tcl_data_app.h"
#include "fc_sxm_tcl_sports_app_interface.h"

/******************************************
 * Forward declarations
 *******************************************/
struct fc_sxm_trMsgCmdAppTtfisCmd;
struct fc_sxm_trMsgSportsMStartGetSportList;
struct fc_sxm_trMsgSportsMStartGetRootAffiliateList;
struct fc_sxm_trMsgSportsMStartGetAffiliateDetails;
struct fc_sxm_trMsgSportsMStartGetAllTeams;
struct fc_sxm_trMsgSportsMStartGetGameList;
struct fc_sxm_trMsgSportsSMSeLeagueCallback;
struct fc_sxm_trMsgSportsMStartGetNewsDetails;
struct fc_sxm_trMsgSportsMStartGetScheduledEvents;
struct fc_sxm_trMsgSportsMStartGetEventRankList;
struct fc_sxm_trMsgSportsMStartGetFavoriteList;
struct fc_sxm_trMsgSportsMStartSetAsFavorite;

class fc_sxm_tclSportsManager;

struct fc_sxm_trSportsTimer: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 212);
};

/******************************************
 * Class declarations
 *******************************************/
class fc_sxm_tclSportsApp :
public fc_sxm_tclDataApp,
public fc_sxm_tclSportsAppIFace,
   public fc_sxm_tclSingleton<fc_sxm_tclSportsApp>
    
{
   friend class fc_sxm_tclSingleton<fc_sxm_tclSportsApp>;
   friend class fc_sxm_tclTimer<fc_sxm_tclSportsApp,
	                                            fc_sxm_trSportsTimer>;

 public:

   static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Sports;


   // Destructor
   virtual ~fc_sxm_tclSportsApp();

   // Initialize the movies service
   virtual tVoid vInitialize(tVoid);

   // DeInitialize the movies service
   virtual tVoid vDeInitialize(tVoid);
   // dispatch thread-messages specific for sports-app
   tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

   virtual tVoid vProcess(fc_sxm_trMsgDataSportsState const *prMsg);

   // Retrieve the sports app instance
   fc_sxm_tclSportsApp *pGetSportsAppReference()
   {
	   //return app reference
	   return this;
   }
   const tChar* pGetTimeZone(){return _strTimeZone.c_str();}
   tBool bGetClockDST() const {return _bIsDSTon;}	


   tU8 u8GetDayMapIndex(tU32) const;

   tVoid vPrintReportSpecific();

public:
   //Over-ridden methods from class fc_sxm_tclSportsAppIFace
   tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult &);
   tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult &);
   tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult &);
   tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult &);
   tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult &);
   tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult &);
   tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult &);
   tVoid vSendErrorMsg(fc_sxm_trAdressing const  &, tInt);
   tVoid vPostInternalMsg(const fc_sxm_trMsgSportsSMSeLeagueCallback & );
   tVoid vSendSportsDataUpdateStatus(tU8 u8SportID, tU32 u32LeagueID , tU8 u8UpdateType, tU8 u8UpdateStatus) const;
   // Start Timer -- On Timer Expiry Send the Property Update Notification to HMI
   tVoid vStartSportsTimer(tU32 u32TimerValue);
   // timer checking
   	tBool bIsSportsTimerRunning(tVoid) const;
 protected:

   SXM_SMSE_DATASRV_ACCESS(NULL, _hSports);
   virtual tVoid vStopSmsService();
   //over ridden from data app to clear the old data during re-initialization of sms service.
   tVoid vClearServiceData(tVoid);

   // commands From CCA-Thread:
   virtual tVoid vStartSmsService();

  private:

	// fi-messages

   virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartGetSportList const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartGetRootAffiliateList const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartGetAffiliateDetails const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartGetAllTeams const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartGetGameList const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartGetScheduledEvents const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartGetEventRankList const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartGetNewsDetails const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartGetFavoriteList const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgSportsMStartSetAsFavorite const *prMsg);
   virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppClearUserData const *prMsg);
   virtual tVoid vProcessTimer(fc_sxm_trSportsTimer const *prMsg);
   virtual tVoid vSetClockParams(fc_sxm_trMsgDataAppSetClockParams const *prMsg);
   //SMSe Callback message - League Updates
   tVoid vProcess(fc_sxm_trMsgSportsSMSeLeagueCallback const *prMsg);


   tVoid vHandleUpdatedState();
   tVoid vCreateSportsList();
   tVoid vCreateLeagueList();
   tVoid vHandleBroadScopeChanges();
   tVoid vUpdateFavoriteList() const;


   //Added for internal TTFIs cmds handling
   tVoid vHandleTTFIsCmdSportList(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vHandleTTFIsCmdRootAffiliateList(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vHandleTTFIsCmdAffiliateDetails(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vHandleTTFIsCmdAllTeams(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vHandleTTFIsCmdSchedules(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vHandleTTFIsCmdEventSchedules(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vHandleTTFIsCmdEventRankList(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vHandleTTFIsCmdNewsDetails(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vHandleTTFIsCmdFavoriteList(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vHandleTTFIsCmdSetAsFavorite(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
   tVoid vSendSportsDataStatus(tU8 u8ServiceStatus) const;
	//stop timer
	tVoid vStopSportsTimer(tVoid);
	// to notify timeout
	tVoid vSportsTimerNotifyTimeOut(tVoid) const;
	tVoid vSetSMSGMTOffSet() const;

	tVoid vNotifyMetaDataUpdate(tBool bUpdateInProgress) const;

 private:

	typedef enum enSportState
	{
		// enums used for identifying state of sport.
		fc_sxm_enSportState_Initial,
		fc_sxm_enSportState_Updating,
		fc_sxm_enSportState_Updated,
		fc_sxm_enSportState_Stopped,
		fc_sxm_enSportState_Error
	} fc_sxm_tenSportState;

   /* Constructor */
   fc_sxm_tclSportsApp();
   SPORTS_SERVICE_OBJECT _hSports;
   fc_sxm_tenSportState _enSportState;

   fc_sxm_tclSportsManager* _poSportsManager;

   string _strTimeZone;
   tBool _bIsDSTon;

   fc_sxm_tclTimer<fc_sxm_tclSportsApp,
	   	   	   	   	   	   	   fc_sxm_trSportsTimer> _mSportsTimer;
  

};

#endif //_FC_SXM_TCL_SPORTS_APP_H_
