/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_pers_sports_data.h
* @brief       File to maintain persistency for Sports application
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PERS_SPORTS_DATA_H
#define FC_SXM_TCL_PERS_SPORTS_DATA_H

#include "fc_sxm_tcl_singleton.h"
#include "fc_sxm_property.h"

/* Forward decleration of trUserConfig struct */
struct trUserConfig;

/* *************************** Sport List *************************** */
struct trSportListElement {                 /* Sport list element     */
	trSportListElement() : u8SportID(0) {   /* Clear sport ID         */ 
		sSportName.clear();                 /* Clear sport name       */
	}
	tU8 u8SportID;                          /* Sport ID               */
	string sSportName;                      /* Sport name             */
};

struct tSXMAudio_ProtectedSportList {
	vector<trSportListElement> vSportList;  /* Sport list             */
};

/* *************************** Root List **************************** */
struct trRootListElement {                  /* Root list element      */
	trRootListElement()
		:u8SportID(0)                       /* Clear sport ID         */
		,u32AffiliateID(0)                  /* Clear affiliate ID     */
		,u8Season(0)                        /* Clear season info      */
	{
		sAffiliateName.clear();             /* Clear affiliate name   */
	}
	tU8 u8SportID;                          /* Sport ID               */
	tU32 u32AffiliateID;                    /* Affiliate ID           */
	string sAffiliateName;                  /* Affiliate name         */
	tU8 u8Season;                           /* Affiliate season       */
};

struct tSXMAudio_ProtectedRootList {
	vector<trRootListElement> vRootList;    /* Root list              */
};

/* ************************* Favorite List ************************** */
struct trFavoriteListElement {              /* Favorite list element  */
	trFavoriteListElement(tU8 u8SPID = 0u, tU32 u32TID = 0u, tU32 u32LID = 0u, tU32 u32GDID = 0u,
			string strTeam = "",string strAbrTeam = "",string strKnownTeam = "",string strNickTeam = "", string strSPName = "")
		:u8SportID(u8SPID)                       /* Clear sport ID         */
		,u32TeamID(u32TID)                       /* Clear team ID          */
		,u32LeagueID(u32LID)                     /* Clear league ID        */
	    ,u32GDRef(u32GDID)                        /* Global reference ID    */
		,sTeamName(strTeam)
		,sTeamAbrName(strAbrTeam)
		,sTeamKnownName(strKnownTeam)
		,sTeamNickName(strNickTeam)
		,sSportName(strSPName)
	{
		// Default constructor
	}

	tU8 u8SportID;                          /* Sport ID               */
	tU32 u32TeamID;                         /* Team ID                */
	tU32 u32LeagueID;                       /* League ID              */
	tU32 u32GDRef;                          /* Global Reference ID    */
	string sTeamName;                       /* Full Team name         */
	string sTeamAbrName;                       /* Abbreviated name         */
	string sTeamKnownName;                       /* Known name         */
	string sTeamNickName;                       /* Nick name         */
	string sSportName;                      /* Affiliate name         */
};

struct tSXMAudio_ProtectedFavoriteList {
	vector<trFavoriteListElement> vFavoriteList;  /* Favorite list    */
};

/* ****************************************************************** */

/* Sports user data class */
class trSportsUserData
	: public fc_sxm_tclSingleton<trSportsUserData>
{
	public:
		/* Class destructor */
		~trSportsUserData();
		/* Call Persistant data  Methods  to Clear Persistant Memory*/
		/* Call Persistant data  Methods  to Clear All Sport Data */
		tVoid vClearSportData(tVoid);
		/* **************************** Sport list access functions **************************** */
		/* Show sport list data */
		tVoid vPrintSportList(tVoid);
		/* Clear sport list */
		tVoid vClearSportList(tVoid);
		/* Update or add new element into sport list */
		tVoid vSetSportList(tU8 u8SportID, string sSportName);
		/* Get sport list size */
		tU32  u32GetSportListSize(tVoid);
		/* Get sport list element for the given index */
		tVoid vGetSportList(tU32 u32Index, tU8 &u8SportID, string &sSportName);
		/* **************************** Root list access functions **************************** */
		/* Show root list data */
		tVoid vPrintRootList(tVoid);
		/* Clear root list */
		tVoid vClearRootList(tVoid);
		/* Update or add new element into root list */
		tVoid vSetRootList(tU8 u8SportID, tU8 u8Season, tU32 u32AffiliateID, string sAffiliateName);
		/* Get root list size */
		tU32  u32GetRootListSize(tVoid);
		/* Get root list element for given index */
		tVoid vGetRootList(tU32 u32Index, tU8 &u8SportID, tU8 &u8Season, tU32 &u32AffiliateID, string &sAffiliateName);
		/* **************************** Favorite list access functions **************************** */
		/* Show favorite list data */
		tVoid vPrintFavoriteList(tVoid);
		/* Clear favorite list */
		tVoid vClearFavoriteList(tVoid);
		/* Update team name of a Favorite List item*/
		tBool bUpdateTeamName(tU8 u8SportID, tU32 u32TeamID, tU32 u32LeagueID, string& strTeamName,
				string& strTeamAbrName,string& strTeamKnownName,string& strTeamNickName);
		/* Clear favorite list element */
		tVoid vClearFavoriteListElement(tU8 u8SportID, tU32 u32TeamID, tU32 u32LeagueID);
		/* Update or add new element into favorite list */
		//tVoid vSetFavoriteList(tU8 u8SportID, tU32 u32TeamID, tU32 u32LeagueID, tU32 u32GDRef, string& sTeamName, string& sSportName);
		/*
		 to fix NCG3D-53
		 */
		tVoid vSetFavoriteList(tU8 u8SportID, tU32 u32TeamID, tU32 u32LeagueID, tU32 u32GDRef, const string& sTeamName,
				const string& sTeamAbrName,const string& sTeamKnownName,const string& sTeamNickName, const string& sSportName);
		/* Get favorite list size */
		tU32  u32GetFavoriteListSize(tVoid);
		/* Get favorite list element for given index */
		tVoid vGetFavoriteList(tU32 u32Index, trFavoriteListElement &FavoriteElement);

        /* Get data */
        tVoid vGetData(tVoid);
        /* Set data */
        tVoid vSetData(tVoid);

	private:
		/* Class constructor */
		trSportsUserData();
		/* Clear all list data */
		tVoid vClearListData();

		/* Declaring singleton class as friend of sports user data class */
		friend class fc_sxm_tclSingleton<trSportsUserData>;
		/* Declare struct trUserConfig as friend of sports user data class */
		friend struct trUserConfig;


	protected:

		/* **************************** Sport list *********************************** */
        fc_sxm_tclProtectedData<tSXMAudio_ProtectedSportList> _mProtectedSportList;
		/* Get data from persistence memory and store it in sport list               */
		tVoid vGetSportListData(tVoid);
		/* Set sport list data into binary data to persist across power cycle    */
		tVoid vSetSportListData(tVoid);
		/* **************************** Root list ************************************ */
        fc_sxm_tclProtectedData<tSXMAudio_ProtectedRootList> _mProtectedRootList;
		/* Get data from persistence memory and store it in root list                */
		tVoid vGetRootListData(tVoid);
		/* Set root list data into binary data to persist across power cycle     */
		tVoid vSetRootListData(tVoid);
		/* ************************** Favorite list ********************************** */
        fc_sxm_tclProtectedData<tSXMAudio_ProtectedFavoriteList> _mProtectedFavoriteList;
		/* Get data from persistence memory and store it in favorite list            */
		tVoid vGetFavoriteListData(tVoid);
		/* Set favorite list data into binary data to persist across power cycle */
		tVoid vSetFavoriteListData(tVoid);
		/* *************************************************************************** */
};

#endif
