/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_phonetics_proxy.cpp
* @brief       Proxy class implementation to interact with SMS library 
*              for Phonetics service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_tcl_phonetics_proxy.h"
#include "fc_sxm_sms_osal.h"


PHONETICS_SERVICE_OBJECT fc_sxm_tclPhoneticsProxy::vStartSmsService(const char *pacSRHDriverName,
        const char *pacOutputDir,
        DATASERVICE_EVENT_MASK tEventRequestMask,
        DATASERVICE_EVENT_CALLBACK vEventCallback,
        void *pvEventCallbackArg,
        PHONETICS_FILE_UPDATE_CALLBACK vFileCallback,
        void *pvFileCallbackArg,
        DATASERVICE_OPTIONS_STRUCT const *psOptions )
{
    return(PHONETICS.hStart(pacSRHDriverName, //SRH driver name
            pacOutputDir,             //Phonetics dic file full path
            tEventRequestMask,        //Caller wished Events
            vEventCallback,           //Event Call back function
            pvEventCallbackArg,       //Event Call back Argument
            vFileCallback,            //File Call back function
            pvFileCallbackArg,        //File Call back Argument
            psOptions                 //Options to config the service
    ));
}

tBool fc_sxm_tclPhoneticsProxy::bGenerateBaselineFile()
{
    return (PHONETICS.bGenerateDistributionFiles(FC_SXM_DEFAULT_SMS_PHONETICS_TTS_PATH,
            FC_SXM_DEFAULT_SMS_PHONETICS_REC_PATH,
            FC_SXM_DEFAULT_SMS_PHONETICS_DB_PATH));
}

SERVICE_ID fc_sxm_tclPhoneticsProxy::hReadServiceIdFromDictionary(OSAL_FILE_STRUCT *psDictionaryFile)
{
    return (PHONETICS.tReadServiceIdFromDictionary(psDictionaryFile));
}


int fc_sxm_tclPhoneticsProxy::iFclose(OSAL_FILE_STRUCT *psDictionaryFile)
{
    return(iSmsFclose(psDictionaryFile));
}

OSAL_FILE_STRUCT* fc_sxm_tclPhoneticsProxy::psFopen(const char *pacDictionaryPath, const char *pcMode)
{
    return (psSmsFopen(pacDictionaryPath, pcMode));
}

tSize fc_sxm_tclPhoneticsProxy::tFread(void *pvDst, tSize size, tSize tNumObj, OSAL_FILE_STRUCT *psFile)
{
    return (tSmsFread(pvDst, size, tNumObj, psFile));
}

int fc_sxm_tclPhoneticsProxy::iFgetc(OSAL_FILE_STRUCT *psFile)
{
    return (iSmsFgetc(psFile));
}


