/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_phonetics_properties.h
* @brief       Declaration of messages used for property notifications for Phonetics service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PHONETICS_PROPERTIES_H
#define FC_SXM_TCL_PHONETICS_PROPERTIES_H

#include "fc_sxm_phonetics_fi.h"

/*
  Semaphore-protected data of phonetics-app
 */


// example for property, where fi-type is stored directly in member "oFiMsg"

struct fc_sxm_tcl_trPhoneticsPropertyNewUpdatePhoneticsInfoListStatus {
    fc_sxm_tcl_trPhoneticsPropertyNewUpdatePhoneticsInfoListStatus(tBool bUpdatePhonetics_= FALSE)
    {
        (void)bUpdatePhonetics_;
    }
    tBool operator!=(fc_sxm_tcl_trPhoneticsPropertyNewUpdatePhoneticsInfoListStatus const& b) const
                        {
        return !(oFiMsg==b.oFiMsg);
                        }

    midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus oFiMsg;

};


class fc_sxm_tclPhonetics_properties:
public fc_sxm_tclSingleton<fc_sxm_tclPhonetics_properties>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclPhonetics_properties>;
public:

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trPhoneticsPropertyNewUpdatePhoneticsInfoListStatus,
    CCA_C_U16_SRV_SXM_PHONETICS, /*the service-id of the CCA-Service */
    MIDW_EXT_SXM_PHONETICSFI_C_U16_PHONETICSUPDATE /* give FID if notification to service is needed  */
    > oNewUpdatePhoneticsInfoListStatus;
};

#endif
