/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_phonetics_channels.h
* @brief       Class declaration for Phonetics Data handling Functionalities.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PHONETICS_CHANNELS_H_
#define _FC_SXM_TCL_PHONETICS_CHANNELS_H_

#include "fc_sxm_tcl_phonetics_base.h"


//Class Declaration
class fc_sxm_tcl_phonetics_channels : public fc_sxm_tclPhoneticsBase
{
public:

    // Constructor
    fc_sxm_tcl_phonetics_channels(){}
    fc_sxm_tcl_phonetics_channels(Ifc_sxm_tclPhoneticsProxy *pIPhoneticsProxy);

    // Destructor
    virtual ~fc_sxm_tcl_phonetics_channels();

    //phonetics files path set method
    tVoid vGetPhoneticsData(midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult &ofiTxObj);

private:
#ifdef UNITTEST_FC_SXM
    // For unit test product, to perform effective unit-testing of all private members,
    // the private methods/variables are made public.
    // In production-code, the methods and variables still remain private
public:
#endif
    //phonetics channels files path set method
    tVoid vGetChannelsPhoneticsData(tU8 LanguageType, vector<midw_ext_fi_tcl_ChannelPhoneticsInfo> &vChannelList);

    //phonetics channel files reading method
    tBool bReadChannelsphoneticsData(const char *pacDictionaryPath, vector<midw_ext_fi_tcl_ChannelPhoneticsInfo> &vChannelPhoneticsData);
};

#endif //_FC_SXM_TCL_PHONETICS_CHANNELS_H_
