/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_phonetics_base_if.h
* @brief       Interface for Phonetics service base class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PHONETICS_BASE_IF_H_
#define _FC_SXM_TCL_PHONETICS_BASE_IF_H_

#include "fc_sxm_types.h"
#include "fc_sxm_sms.h"
#include "fc_sxm_tcl_phonetics_fi_msgs.h"

//forward declaration
class midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus;
class midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult;
class midw_ext_fi_tcl_ChannelPhoneticsInfo;
class midw_ext_fi_tclString;

//Class Declaration
class fc_sxm_tclIPhoneticsBase{
public:

    virtual tVoid vConvertPhoneticsInfo(midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus &oFiMsg) = 0;

    //phonetics files path set method
    virtual tVoid vGetPhoneticsData(midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult &ofiTxObj) = 0;

    //phonetics string parser method
    virtual tBool bReadPhoneticEntry(OSAL_FILE_STRUCT *psPhoneticsFile, vector<midw_ext_fi_tclString> &vChannelString) = 0;

    virtual ~fc_sxm_tclIPhoneticsBase(){};
};


#endif //_FC_SXM_TCL_PHONETICS_BASE_IF_H_
