/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_phonetics_app.h
* @brief       Application handler declaration for Phonetics service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PHONETICS_APP_H_
#define _FC_SXM_TCL_PHONETICS_APP_H_

#include "fc_sxm_tcl_data_app.h"
#include "fc_sxm_tcl_phonetics_properties.h"
#include "fc_sxm_tcl_phonetics_fi_msgs.h"

//Forward Declarations
struct fc_sxm_trMsgCmdAppTtfisCmd;
class fc_sxm_tclIPhoneticsBase;
class Ifc_sxm_tclPhoneticsProxy;

//Class Declaration
class fc_sxm_tclPhoneticsApp :
public fc_sxm_tclDataApp,
public fc_sxm_tclSingleton<fc_sxm_tclPhoneticsApp>

{

    friend class fc_sxm_tclSingleton<fc_sxm_tclPhoneticsApp>;

public:

    //Service ID for Phonetics
    static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Phonetics;

    // Destructor
    virtual ~fc_sxm_tclPhoneticsApp();

    // Initialize the phonetics service
    virtual tVoid vInitialize(tVoid);

    // DeInitialize the phonetics service
    virtual tVoid vDeInitialize(tVoid);

    // dispatch thread-messages specific for phonetics-app
    tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

    virtual tVoid vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg);


    //method to print phonetics Report
    tVoid vPrintReportSpecific();

    //  tVoid vUpdatePhoneticsInfo(tU8 eFileType, tU8 eLanguage);

    //vProcess for Property update by SMS file event callback
    tVoid vProcess(fc_sxm_trMsgPhoneticsSMSFileEventCallback const *prMsg);

    tVoid vProcess(fc_sxm_trMsgDataMStartGetPhoneticsData const *prMsg);

protected:

    SXM_SMS_DATASRV_ACCESS(PHONETICS, _hPhonetics);

    // Start the service (Mandatory, dispatched by Base-Class)
    virtual tVoid vStartSmsService();

    //over ridden from data app to clear the old data during re-initialization of sms service.
    tVoid vClearServiceData(tVoid);

    //Other private Methods
private:

    // fi-messages
    virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);
    tVoid vHandleTTFIsCmdGetChannelNames(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
    //member variables
private:

    /* Constructor */
    fc_sxm_tclPhoneticsApp();

    // Phonetics Object
    PHONETICS_SERVICE_OBJECT _hPhonetics;
    fc_sxm_tclIPhoneticsBase* _pPhoneticsBase;
    Ifc_sxm_tclPhoneticsProxy* _poPhoneticsProxy;

};

#endif //_FC_SXM_TCL_PHONETICS_APP_H_
