/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_sdk_proxy.cpp
* @brief       Source file which acts as interface between fc_sxm app
*              and SMS library for SportsFlash specific calls.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_tcl_parking_sdk_proxy.h"

fc_sxm_tclParkingSdkProxy::fc_sxm_tclParkingSdkProxy()
{
    // Default CTOR
}

fc_sxm_tclParkingSdkProxy::~fc_sxm_tclParkingSdkProxy()
{

}

// Use all SMS calls specific for sports flash

//Parking Service - start
tS32 fc_sxm_tclParkingSdkProxy::s32StartService(void (*callback)(int, int), int debug) const
{
    return (tS32)sxm_parking_start(callback,debug);
}
//Parking Service - status
tS32 fc_sxm_tclParkingSdkProxy::s32ServiceStatus(SXMStatus* status) const
{
    return (tS32)sxm_parking_status(status);
}
//Parking Service - stop
tS32 fc_sxm_tclParkingSdkProxy::s32StopService() const
{
    return (tS32)sxm_parking_stop();
}
//Parking collection - Request
tS32 fc_sxm_tclParkingSdkProxy::s32StartRequest(SXMMBR *mbr, SXMPoint *center, void (*callback)(ptr, ptr), ptr usercx, ptr *handle) const
{
    return (tS32)sxm_parking_request(mbr,center,callback,usercx,handle);
}
//Parking collection - modify
tS32 fc_sxm_tclParkingSdkProxy::s32ModifyRequest(ptr handle, SXMMBR *mbr, SXMPoint *center) const
{
    return (tS32)sxm_parking_modify(handle,mbr,center);
}
//Parking collection - remove
tS32 fc_sxm_tclParkingSdkProxy::s32RemoveCollection(ptr handle) const
{
    return (tS32)sxm_parking_remove(handle);
}
//Parking collection - start
tS32 fc_sxm_tclParkingSdkProxy::s32BeginExtraction(ptr handle, SXMPoint *center) const
{
    return (tS32)sxm_parking_begin(handle,center);
}
//Parking Service - ExtractParkingLocation
tS32 fc_sxm_tclParkingSdkProxy::s32ExtractParkingLocation(ptr handle, SXMParkingLocation *pLocation) const
{
    return (tS32)sxm_parking_extract_location(handle,pLocation);
}
//Parking Extraction - End
tS32 fc_sxm_tclParkingSdkProxy::s32EndExtraction(ptr handle) const
{
    return (tS32)sxm_parking_end(handle);
}
//Parking collection for POI - begin
tS32 fc_sxm_tclParkingSdkProxy::s32POIBeginExtraction(const SXMMBR *mbr, ushort filterMask) const
{
    return (tS32)sxm_parking_poi_begin(mbr,filterMask);
}
//Parking collection for POI - extract
tS32 fc_sxm_tclParkingSdkProxy::s32POIExtractParkingLocation(SXMParkingLocation *pLocation) const
{
    return (tS32)sxm_parking_poi_extract_station(pLocation);
}
//Parking collection for POI - End
tS32 fc_sxm_tclParkingSdkProxy::s32POIEndExtraction() const
{
    return (tS32)sxm_parking_poi_end();
}
//Parking collection for POI - begin
tS32 fc_sxm_tclParkingSdkProxy::s32SetPPOIList(const uint specCnt, const PPOISpec *specs ,
        void (*notification)(ptr, byte), ptr usercx) const
{
    return (tS32)sxm_parking_set_ppoi_list(specCnt,specs,notification,usercx);
}
//Parking Service - GetClosest Point
tF32 fc_sxm_tclParkingSdkProxy::f32GetClosestPoint(SXMPoint */*sort*/) const
{
    return 0.0;
}
//Parking Service - GetFarthestPoint
tF32 fc_sxm_tclParkingSdkProxy::f32GetFarthestPoint(SXMPoint */*sort*/) const
{
    return 0.0;
}
