/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_neardest.h
* @brief       Class to handle Near Destination Parking Data
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_NEARDEST_H_
#define _FC_SXM_TCL_PARKING_NEARDEST_H_

#include "fc_sxm_tcl_parking_base.h"

struct trDestPOIs
{
	tU32 u32ParkingID;
	tF32 f32Distance;
	trPOIData rTempPOIData;
	trDestPOIs():
		u32ParkingID(0U),
		f32Distance(0.0F)
	{

	}

};
struct trComparedata {
	bool operator()(trDestPOIs const prLeft, trDestPOIs const prRight) const {
		return prLeft.f32Distance < prRight.f32Distance;
	}
};

//Class Declaration
class fc_sxm_tclParkingNearDest :
            public fc_sxm_tclParkingBase,
            public fc_sxm_tclSingleton<fc_sxm_tclParkingNearDest>

{
    friend class fc_sxm_tclSingleton<fc_sxm_tclParkingNearDest>;

public:

    /* Constructor */
    fc_sxm_tclParkingNearDest();

    // Destructor
    virtual ~fc_sxm_tclParkingNearDest();

    virtual tS32 s32RefreshPOIList() ;

    virtual tVoid vClearPPOIUserFlag();

    //member variables
private:


};

#endif //_FC_SXM_TCL_PARKING_NEARDEST_H_
