/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_nearby.h
* @brief       Class to handle Near By Parking Data
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_NEARBY_H_
#define _FC_SXM_TCL_PARKING_NEARBY_H_

#include "fc_sxm_tcl_parking_base.h"

//Class Declaration
class fc_sxm_tclParkingNearBy :
            public fc_sxm_tclParkingBase,
            public fc_sxm_tclSingleton<fc_sxm_tclParkingNearBy>

{
    friend class fc_sxm_tclSingleton<fc_sxm_tclParkingNearBy>;

public:

    // Constructor
    fc_sxm_tclParkingNearBy();

    // Destructor
    virtual ~fc_sxm_tclParkingNearBy();

    //Remove the Request
    virtual tVoid vRemoveRequest();

    // Start the Request
    virtual tVoid vStartRequest();

    //To get full parking List
    virtual tS32 s32GetParkingList(midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult &);

    //to get particular parking location
    virtual tS32 s32GetParkingInfo(tU32,midw_ext_fi_tcl_ParkingInfo &);


    //member variables
private:

};

#endif //_FC_SXM_TCL_PARKING_NEARBY_H_
