/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_favorites.h
* @brief       Class to handle favorites Parking Data
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_FAVORITES_H_
#define _FC_SXM_TCL_PARKING_FAVORITES_H_

#include "fc_sxm_tcl_parking_base.h"
#include "fc_sxm_tcl_parking_common.h"

//Class Declaration
class fc_sxm_tclParkingFavorites :
            public fc_sxm_tclParkingBase,
            public fc_sxm_tclSingleton<fc_sxm_tclParkingFavorites>

{
    friend class fc_sxm_tclSingleton<fc_sxm_tclParkingFavorites>;

public:

    /* Constructor */
    fc_sxm_tclParkingFavorites();

    // Destructor
    virtual ~fc_sxm_tclParkingFavorites();

    virtual tBool bAddFavorite(tU32);

    virtual tBool bRemoveFavorite(tU32);

    virtual tVoid vClearPOIUserFlag(tU32);

    //member variables
private:

    tU32 _u32CurrentOrder;


};

#endif //_FC_SXM_TCL_PARKING_FAVORITES_H_
