/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_factory.h
* @brief       factory class declaration.
* 			   class responsible for creating parking list objects required.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_FACTORY_H_
#define _FC_SXM_TCL_PARKING_FACTORY_H_

#include "fc_sxm_tcl_parking_factory_if.h"

/*
 * Parking object factory declaration
 */
class fc_sxm_tclParkingFactory : public fc_sxm_tclIParkingFactory,
                            public fc_sxm_tclSingleton<fc_sxm_tclParkingFactory>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclParkingFactory>;

public:
    virtual fc_sxm_tclIParkingBase *poGetParkingList(tU8 u8ID) const;
    virtual ~fc_sxm_tclParkingFactory() { }

private:
    fc_sxm_tclIParkingBase *poCreateList(tU8 u8ID) const;

private:
    fc_sxm_tclParkingFactory() {};
};

#endif  /* _FC_SXM_TCL_PARKING_FACTORY_H_ */
