/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_factory.cpp
* @brief       Implementation of Parking factory class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_tcl_parking_factory.h"
#include "fc_sxm_tcl_parking_nearby.h"
#include "fc_sxm_tcl_parking_neardest.h"
#include "fc_sxm_tcl_parking_favorites.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "fc_sxm_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_PARKING_APP
#include "trcGenProj/Header/fc_sxm_tcl_parking_factory.cpp.trc.h"
#endif

/*
 * Method creates a new list object based on ListID
 */
fc_sxm_tclIParkingBase * fc_sxm_tclParkingFactory::poCreateList(tU8 u8ID) const
{
    //Method returns a new parking list based on listID
    switch((midw_ext_fi_tcl_e8_SxmListType::tenType)u8ID)
    {
        case midw_ext_fi_tcl_e8_SxmListType::FI_EN_NEAR_BY:
            return fc_sxm_tclParkingNearBy::instance();
        case midw_ext_fi_tcl_e8_SxmListType::FI_EN_NEAR_DESTINATION:
            return fc_sxm_tclParkingNearDest::instance();
        case midw_ext_fi_tcl_e8_SxmListType::FI_EN_FAVORITE:
            return fc_sxm_tclParkingFavorites::instance();
        default:
            return OSAL_NULL;
    }
}

/*
 * Parking list Object Factory implementation
 */
fc_sxm_tclIParkingBase * fc_sxm_tclParkingFactory::poGetParkingList(tU8 u8ID) const
{
    // Return parking object based on the input configurations provided to the Factory
    ETG_TRACE_USR4(("fc_sxm_tclParkingFactory::getParkingList u8ID =%u",u8ID));

    return poCreateList( u8ID);
}
