/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_common.h
* @brief       Parking common declarations that would be used across whole of Parking service
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PARKING_COMMON_H_
#define FC_SXM_TCL_PARKING_COMMON_H_

#include "fc_sxm_types.h"
#include "fc_sxm_smse.h"

#define FC_SXM_PARKING_NO_FILTER (SXM_LOCATION_IS_IN_PPOIS | (0x0000))
#define FC_SXM_PARKING_DEST_FILTER_MASK (SXM_LOCATION_IS_IN_PPOIS | (0x0004))
#define FC_SXM_PARKING_FAV_FILTER_MASK (SXM_LOCATION_IS_IN_PPOIS | (0x0001))

struct trPOIData
{
	ushort u16Userflag;       //both
    tU32 u32Index;     //favorites
    trPOIData():
    	u16Userflag(0U),
		u32Index(0U)
    {

    }
};

#endif /* FC_SXM_TCL_PARKING_COMMON_H_ */

