/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_base_if.h
* @brief       interface class for parking base
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_BASE_IF_H_
#define _FC_SXM_TCL_PARKING_BASE_IF_H_

#include "fc_sxm_types.h"
#include "fc_sxm_tcl_parking_common.h"

//forward declaration
class fc_sxm_tclIParkingApp;
class fc_sxm_tclIParkingSdkProxy;
class midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult;
class midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart;
class midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart;
class midw_ext_fi_tcl_ParkingInfo;
class midw_ext_fi_tcl_e8_SxmListMode;

//Class Declaration
class fc_sxm_tclIParkingBase{
public:
    virtual tVoid vSetApp(fc_sxm_tclIParkingApp *,fc_sxm_tclIParkingSdkProxy*) = 0;

    virtual tVoid vSetPosition(tS32 s32Lon,tS32 s32Lat) = 0;
    virtual tVoid vPrepareMBR() = 0;
    virtual tVoid vRemoveRequest() = 0;
    virtual tVoid vStartRequest() = 0;
    virtual tS32 s32GetParkingList(midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult &) = 0;
    //to get particular parking location
    virtual tS32 s32GetParkingInfo(tU32,midw_ext_fi_tcl_ParkingInfo &) = 0;

    virtual tVoid vSetFilterConfig(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart &) = 0;
    virtual tVoid vSetFilterConfig(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart &) = 0;

    virtual tS32 s32RefreshPOIList() = 0;
    virtual tBool bAddFavorite(tU32) = 0;
    virtual tBool bRemoveFavorite(tU32) = 0;

    virtual tS32 s32SetPPOIList(vector<PPOISpec>&) = 0;

    virtual const map<tU32,trPOIData>& mapGetPOIList() const = 0;

    virtual tVoid vClearPOIList() = 0;

    virtual tVoid vClearPOIUserFlag(tU32) = 0;
    virtual tVoid vClearPPOIUserFlag() = 0;

    //for debugging purpose only
    virtual tVoid vPrintParkingList(midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult &) const = 0;
    virtual tVoid vPrintParkingInfo(midw_ext_fi_tcl_ParkingInfo &) const = 0;

    virtual tU32 u32GetListID() const = 0;

    virtual tVoid vSetListMode(const midw_ext_fi_tcl_e8_SxmListMode&) = 0;

    virtual const midw_ext_fi_tcl_e8_SxmListMode& trGetListMode() = 0;

    virtual ~fc_sxm_tclIParkingBase(){};
};


#endif //_FC_SXM_TCL_PARKING_BASE_IF_H_
