/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_movies_properties.h
* @brief       Declaration of messages used for property notifications for Movies service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_MOVIES_PROPERTIES_H
#define FC_SXM_TCL_MOVIES_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_movies_fi.h"

/*
  Semaphore-protected data of movies-app
*/


/* example for property, where fi-type is stored directly in member "oFiMsg" */
struct fc_sxm_tcl_trMoviesPropertyListsStatus {
   /* constructor */
   fc_sxm_tcl_trMoviesPropertyListsStatus()
   {}
   /* overloading comparision operator */
   bool operator!=(fc_sxm_tcl_trMoviesPropertyListsStatus const& b) const
   {
     return !(oFiMsg==b.oFiMsg);
   }
   /* stores TheaterList Status information */
   midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus oFiMsg;
 
};

struct fc_sxm_tcl_trMoviesPropertySxmServiceStatus {
    /* constructor */
    fc_sxm_tcl_trMoviesPropertySxmServiceStatus()
    {}
    /* stores TheaterList Status information */
    bool operator!=(fc_sxm_tcl_trMoviesPropertySxmServiceStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* stores SXM Data Service Status information */
    midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus oFiMsg;
 
};

struct fc_sxm_tcl_trMoviesPropertySxmListMode {
    /* constructor */
	fc_sxm_tcl_trMoviesPropertySxmListMode()
    {}
    /* stores TheaterList Status information */
    bool operator!=(fc_sxm_tcl_trMoviesPropertySxmListMode const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* stores SXM Data Service Status information */
    midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus oFiMsg;

};

class fc_sxm_tclMoviesProperties:
public fc_sxm_tclSingleton<fc_sxm_tclMoviesProperties>
{
   friend class fc_sxm_tclSingleton<fc_sxm_tclMoviesProperties>;
public:

   fc_sxm_tclProperty<fc_sxm_tcl_trMoviesPropertyListsStatus, 
      CCA_C_U16_SRV_SXM_MOVIES, /*the service-id of the CCA-Service */
      MIDW_EXT_SXM_MOVIESFI_C_U16_THEATRELISTSSTATUS /* give FID if notification to service is needed  */
   > oListsStatus;

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trMoviesPropertySxmServiceStatus, 
        CCA_C_U16_SRV_SXM_MOVIES, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_MOVIESFI_C_U16_SXMDATASERVICESTATUS /* give FID if notification to service is needed  */
        > oSxmServiceStatus;

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trMoviesPropertySxmListMode,
           CCA_C_U16_SRV_SXM_MOVIES, /*the service-id of the CCA-Service */
		   MIDW_EXT_SXM_MOVIESFI_C_U16_SXMLISTMODE /* give FID if notification to service is needed  */
           > oSxmListMode;
};

#endif
