/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_movies_app.h
* @brief       Application handler declaration for Movies service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_MOVIES_APP_H_
#define _FC_SXM_TCL_MOVIES_APP_H_

#include "fc_sxm_movies_fi.h"

#include "fc_sxm_tcl_movies_properties.h"
#include "fc_sxm_tcl_data_app.h"
#include "fc_sxm_tcl_theater_list.h"


struct fc_sxm_trMsgCmdAppTtfisCmd;

class fc_sxm_tclMoviesDSRL;
struct fc_sxm_trMoviesDSRLCfg;
struct fc_sxm_trTheatreListEntry;

/* 
	messges representing callbacks from sms 
*/
struct fc_sxm_trMsgMoviesMStartSetListsConfig: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 103);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart oFiMsg;

};

struct fc_sxm_trMsgMoviesMStartGetTheatreList: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 104);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart oFiMsg;
	
};

struct fc_sxm_trMsgMoviesMStartGetTheaterInfo: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 105);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart oFiMsg;

};
struct fc_sxm_trMsgMoviesMStartGetMoviesList: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 106);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart oFiMsg;

};
struct fc_sxm_trMsgMoviesMStartGetMovieInfo: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 107);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart oFiMsg;

};
struct fc_sxm_trMsgMoviesMAddFavorite: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 108);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart oFiMsg;

};
struct fc_sxm_trMsgMoviesMRemoveFavorite: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 109);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart oFiMsg;

};
struct fc_sxm_trMsgMoviesMSearchMovie: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 111);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart oFiMsg;

};

struct fc_sxm_trPropertyMoviesPSetListMode: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 112);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_moviesfi_tclMsgSxmListModeSet oFiMsg;

};

#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING
/* messages send for timer concept */
struct fc_sxm_trMsgListUpdateTimer: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Movies, 113);
};
#endif

/*
  the movies-app class
*/
class fc_sxm_tclMoviesApp : 
public fc_sxm_tclDataApp,
   public fc_sxm_tclSingleton<fc_sxm_tclMoviesApp>
    
{
   friend class fc_sxm_tclSingleton<fc_sxm_tclMoviesApp>;

 public:

   static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Movies;

   /* Destructor */
   virtual ~fc_sxm_tclMoviesApp();

   /* Initialize the movies service */
   virtual tVoid vInitialize(tVoid);

   /* DeInitialize the movies service */
   virtual tVoid vDeInitialize(tVoid);

#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING

   virtual tVoid vProcessTimer(fc_sxm_trMsgListUpdateTimer const *prMsg);

   /*
      start the timer for 10 seconds
   */
    tVoid vStartListTimer(tVoid);
    tVoid vStopListTimer(tVoid);
    tBool bIsListUpdateTimerRunning(tVoid) const;
#endif

   /* dispatch thread-messages specific for movies-app */
   tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);
   /* 
	Method to Extract SMS Location Object to FI Location type
   */
   midw_ext_fi_tcl_SxmLocation rGetTheaterLocation(LOCATION_OBJECT hLocObj) const;
   
   /* Method to Print Movies List */
   tVoid vPrintMovies(midw_ext_fi_tcl_MoviesList const &oMoviesList) const ;
   
   /* Method to Sort the List using selection Sort */
   tVoid vSortList(midw_ext_fi_tcl_MoviesList &oMoviesList)const ;
   /* 
	Method to Print Local Time to Console
   */
   tVoid vPrintLocalTime() const;

   tVoid vPrintReportSpecific();
   /* 
	   SMS CallBack method to iterate Movie entries
   */
   static BOOLEAN bIterateUSMovies(MOVIE_OBJECT hMovie,void *pvEventCallbackArg);
   /* 
      Method used to Check string for Invalid values(e.g n/a)
   */
   tVoid vCheckForInvalidString(midw_ext_fi_tclString &rString) const;

 protected:
   virtual tVoid vOnListStateChanged(fc_sxm_tclDataListBase *poDataList);
   virtual tVoid vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState);

   SXM_SMS_DATASRV_ACCESS(MOVIES, _hMovies);

   /* commands From CCA-Thread: */

   /* Start the service (Mandatory, dispatched by Base-Class) */
   virtual tVoid vStartSmsService();

   //Favorite methods to be implemented
   virtual tVoid vRestoreFavorites();
   virtual tVoid vPersistFavorites();
  private:
   tBool bIsFavorite(tU32 u32LocID) const;
   /*
      Method To Get complete movies list playing in US from SMS
   */
   tVoid vGetUSMoviesList();
   /* process TTFIS commands */
   virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);
	
   /* messages specific for movies-app */    

   /* fi-messages */

   virtual tVoid vProcess(fc_sxm_trMsgMoviesMStartSetListsConfig  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgMoviesMStartGetTheatreList  const*prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgMoviesMStartGetTheaterInfo const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgMoviesMStartGetMoviesList const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgMoviesMStartGetMovieInfo const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgMoviesMAddFavorite  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgMoviesMRemoveFavorite  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgMoviesMSearchMovie  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trPropertyMoviesPSetListMode  const *prMsg); 
   virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppClearUserData const *prMsg);

 private:

   /* Constructor */
   fc_sxm_tclMoviesApp();

   tVoid vCreateDsrlAndList(fc_sxm_tenDSRLType enDsrlType, fc_sxm_tenListType enListType, 
                           fc_sxm_tclMoviesDSRL **ppoDsrl, fc_sxm_trMoviesDSRLCfg rDsrlCfg,
                           fc_sxm_trTheatreList **ppoTheaterList,fc_sxm_trTheatreListConfig const &rListCfg);
   /* 
	   Method to handle "List Movies" request
   */
   tVoid vGetListMovies(tU32 u32ListId,fc_sxm_trAdressing const &rAdressing);
   /* 
   Method to handle Movies list playing in selected theater
   */
   tVoid vGetMoviesListForSelectedTheater(tU32 u32ListId,tU32 u32LocId,fc_sxm_trAdressing const &rAdressing);

   MOVIES_SERVICE_OBJECT _hMovies;
   fc_sxm_tclMoviesDSRL *_poNearByDsrl;
   fc_sxm_tclMoviesDSRL *_poFavoriteDsrl;
   fc_sxm_trTheatreList *_poNearbyTheatreList;
   fc_sxm_trTheatreList *_poFavoriteTheatreList;
   
   tU32 _u32NearbyCapacity;
   tU32 _u32NearbyRadius;
#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING
   /* Timer to handle List updates */
   fc_sxm_tclTimer<fc_sxm_tclMoviesApp, 
       fc_sxm_trMsgListUpdateTimer> _mListUpdateTimer;

#endif
};

#endif //_FC_SXM_TCL_MOVIES_APP_H_
