/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_fuel_properties.h
* @brief       Declaration fuel service properties
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_FUEL_PROPERTIES_H
#define FC_SXM_TCL_FUEL_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_fuel_fi.h"

/*
  Semaphore-protected data of fuel-app
*/


/* example for property, where fi-type is stored directly in member "oFiMsg"*/
/* Property To Send Status*/
struct fc_sxm_tcl_trFuelPropertyListsStatus {
    /* constructor */
    fc_sxm_tcl_trFuelPropertyListsStatus()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trFuelPropertyListsStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Fuel Info List status */
    midw_ext_sxm_fuelfi_tclMsgFuelInfoListsStatusStatus oFiMsg;
 
};

/* Property To Send Available Brand Name*/

struct fc_sxm_tcl_trFuelPropertyBrandNameListStatus {
    /* constructor */
    fc_sxm_tcl_trFuelPropertyBrandNameListStatus()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trFuelPropertyBrandNameListStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Fuel Brand Name List status */
    midw_ext_sxm_fuelfi_tclMsgFuelBrandNameListStatus oFiMsg;
 
};

/* Property To Send Fuel Type Name List*/

struct fc_sxm_tcl_trFuelPropertyTypeListStatus {
    /* constructor */
    fc_sxm_tcl_trFuelPropertyTypeListStatus()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trFuelPropertyTypeListStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Fuel Type List status */
    midw_ext_sxm_fuelfi_tclMsgFuelTypeListStatus oFiMsg;
 
};

/* Property To Send Service status*/

struct fc_sxm_tcl_trFuelPropertySxmServiceStatus {
    /* constructor */
    fc_sxm_tcl_trFuelPropertySxmServiceStatus()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trFuelPropertySxmServiceStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Sxm data service status */
    midw_ext_sxm_fuelfi_tclMsgSxmDataServiceStatusStatus oFiMsg;
 
};

/* Property To Send SxmListMode status*/

struct fc_sxm_tcl_trFuelPropertySxmListMode {
    /* constructor */
	fc_sxm_tcl_trFuelPropertySxmListMode()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trFuelPropertySxmListMode const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Sxm data service status */
    midw_ext_sxm_fuelfi_tclMsgSxmListModeStatus oFiMsg;

};

    class fc_sxm_tclFuelProperties:
    public fc_sxm_tclSingleton<fc_sxm_tclFuelProperties>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclFuelProperties>;
 public:

    fc_sxm_tclProperty<fc_sxm_tcl_trFuelPropertyListsStatus, 
        CCA_C_U16_SRV_SXM_FUEL, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_FUELFI_C_U16_FUELINFOLISTSSTATUS /* give FID if notification to service is needed  */
        > oListsStatus;
    
    fc_sxm_tclAutoProperty<fc_sxm_tcl_trFuelPropertyBrandNameListStatus, 
        CCA_C_U16_SRV_SXM_FUEL, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_FUELFI_C_U16_FUELBRANDNAMELIST /* give FID if notification to service is needed  */
        > oBrandNameStatus;
      
    fc_sxm_tclAutoProperty<fc_sxm_tcl_trFuelPropertyTypeListStatus, 
        CCA_C_U16_SRV_SXM_FUEL, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_FUELFI_C_U16_FUELTYPELIST /* give FID if notification to service is needed  */
        > oTypeNameStatus;        

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trFuelPropertySxmServiceStatus, 
        CCA_C_U16_SRV_SXM_FUEL, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_FUELFI_C_U16_SXMDATASERVICESTATUS /* give FID if notification to service is needed  */
        > oSxmServiceStatus;


    fc_sxm_tclAutoProperty<fc_sxm_tcl_trFuelPropertySxmListMode,
        CCA_C_U16_SRV_SXM_FUEL, /*the service-id of the CCA-Service */
		MIDW_EXT_SXM_FUELFI_C_U16_SXMLISTMODE /* give FID if notification to service is needed  */
        > oSxmListMode;

};

#endif
