/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_fuel_types.h
* @brief       Defines fuel type and sort method.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef FC_SXM_FUEL_TYPES_H
#define FC_SXM_FUEL_TYPES_H

#include "fc_sxm_sms.h"
#include "fc_sxm_tcl_base_dsrl.h"

// SMS-default sort-method must have number 0
typedef enum
{
   fc_sxm_enFuelDSRLSortMethod_NONE,
   fc_sxm_enFuelDSRLSortMethod_PRICE,
   fc_sxm_enFuelDSRLSortMethod_DISTANCE,
   fc_sxm_enFuelDSRLSortMethod_BRANDNAME,
   fc_sxm_enFuelDSRLSortMethod_FIRST_SAVED_FIRST

} fc_sxm_tenFuelDSRLSortMethod;


// filter-configuration must provide operator!=
struct fc_sxm_trFuelDSRLFilterCfg {
    FUEL_TYPE_ENUM enFuelType;
    string  sBrand;

    fc_sxm_trFuelDSRLFilterCfg() :
       enFuelType(FUEL_TYPE_UNKNOWN),
       sBrand("")
    {}
    // to check if filter has chanded, configuration has to provice operator!= 
    bool operator!=(fc_sxm_trFuelDSRLFilterCfg const &b) const {
        SXM_RET_1_IF_NEQ(enFuelType);
        SXM_RET_1_IF_NEQ(sBrand);
        return false;
    }

};




#endif
