/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_channelart_data.h
* @brief       Declaration for channel art data class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/
#ifndef FC_SXM_TCL_CHANNELART_DATA_H
#define FC_SXM_TCL_CHANNELART_DATA_H

#include "fc_sxm_tcl_channelart_app.h"

/* 
 * Class fc_sxm_tclChannelList to handle all channels related information 
 * for sxm audio.
 */
class fc_sxm_tclChannelArtData:public fc_sxm_tclSingleton<fc_sxm_tclChannelArtData>
{
    /*=========================================================================
    =======                     public section                          =======
    =========================================================================*/
    public:

        /* Class destructor */
        ~fc_sxm_tclChannelArtData();

        /* ================== CCA Request Handlers ========================= */

        // CCA request to audio channel list class 
        tVoid vProcess(fc_sxm_trMsgChannelartMStartGetChannelArt const *prMsg);

        tVoid vProcess(fc_sxm_trMsgChannelartMStartGetChannelArtList const *prMsg);

        static tVoid vProcessChannelArtData(IMAGE_OBJECT hImageObject,
                                    midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult *pofiTxObj);
        tVoid vProcessChannelArtDataList(IMAGE_OBJECT hImageObject,
        							midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult *pofiTxObj) const;

        static tVoid vProcessAlbumArtData(IMAGE_OBJECT hImageObject,
									midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult *pofiTxObj);

        tVoid vSetChannelArtServiceState( tBool bServiceState);


        static tVoid vGetChanArtInfoAccess(CHANNEL_ART_OBJECT &hChannelArtObj, void *pvArg);

       //static tVoid vGetAlbumArtInfoAccess(CHANNEL_ART_OBJECT &hChannelArtObj, void *pvArg);
        static tVoid vAccessChannelArtObject(DECODER_OBJECT &hDecoderObject, CHANNEL_ID &tChannelId,
        							midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult &ofiTxObj);
        
        static tVoid vAccessChannelArtListObject(DECODER_OBJECT &hDecoderObject, CHANNEL_ID &tChannelId,
        							midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult &ofiTxObj);

        tVoid vSetChanArtListState(tBool bSetChanArtListState);

        tBool bGetChanArtListState() const
        {
        	return _bGetChannelArtList;
        }


        /* ================ Timer utility functions ======================== */

    /*=========================================================================
    =======                     private section                         =======
    =========================================================================*/
    private:

        /* ===================== Friend Classes ============================ */

        /* Defining singleton class as a friend class in channel list class */
        friend class fc_sxm_tclSingleton<fc_sxm_tclChannelArtData>;

        /* ==================== Member Functions =========================== */

        /* Class constructor */
        fc_sxm_tclChannelArtData();
       

        /* ==================== Member Variables =========================== */

        tBool _bChannelArtServiceReady;
        tBool _bGetChannelArtList;
        tU16  _u16SID;


    /*=========================================================================
    =======                    protected section                        =======
    =========================================================================*/
    protected:

};

#endif
