/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_channelart_data.cpp
* @brief       Processes the channel art service data received from SMS
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#include "fc_sxm_types.h"
#include "fc_sxm_service_sxm_channelart.h"
#include "fc_sxm_tcl_channelart_data.h"
#include "fc_sxm_tcl_audio_app.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_CHANNELART_APP
#include "trcGenProj/Header/fc_sxm_tcl_channelart_data.cpp.trc.h"
#endif


/*********************************************************************
 *
 *FUNCTION:     fc_sxm_tclChannelArtData
 *
 *DESCRIPTION:  constructor
 *             
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
fc_sxm_tclChannelArtData::fc_sxm_tclChannelArtData()
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelArtData constructor"));
    _bChannelArtServiceReady = FALSE;
    _bGetChannelArtList = FALSE;
    _u16SID = 0;

}

/*********************************************************************
 *
 *FUNCTION:     ~fc_sxm_tclChannelArtData
 *
 *DESCRIPTION:  Destructor
 *             
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
fc_sxm_tclChannelArtData::~fc_sxm_tclChannelArtData()
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelArtData destructor"));
    _bChannelArtServiceReady = FALSE;
    _bGetChannelArtList = FALSE;
	_u16SID = 0;
}

/*********************************************************************
 *
 *FUNCTION:     cb_vChannelArtAccessCallback
 *
 *DESCRIPTION:  Channel Art callback
 *             
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
/* Channel art access callback */
static tVoid cb_vChannelArtAccessCallback(
    CHANNEL_ART_OBJECT hChannelArtObj,
    CHANNEL_ART_AVAILABLE_IMAGE_MASK tAvailableImages,
    void* pvArg)
{
    midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult *pofiTxObj= static_cast <midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult *> (pvArg);

	IMAGE_OBJECT hImageObject;

	ETG_TRACE_USR4(("tAvailableImages - %d", tAvailableImages));
	if (tAvailableImages == CHANNEL_ART_AVAILABLE_IMAGE_LOGO)
	{
		SMSAPI_RETURN_CODE_ENUM eRes =
		CHANNEL_ART.eImage(hChannelArtObj,
						   CHANNEL_ART_IMAGETYPE_LOGO,
						   &hImageObject,
						   NULL);

		if (eRes != SMSAPI_RETURN_CODE_SUCCESS) {
			ETG_TRACE_ERR(("cb_vChannelArtAccessCallback: failed"));
			return;}
		/* Extract channel art info from image object */
		ETG_TRACE_USR4(("Sending Channel Art Image"));
		if (!(fc_sxm_tclChannelArtData::instance()->bGetChanArtListState())) {
			fc_sxm_tclChannelArtData::vProcessChannelArtData(hImageObject, pofiTxObj);
		}
		else {
			midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult *pofiTxObjList= static_cast <midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult *> (pvArg);
			fc_sxm_tclChannelArtData::instance()->vProcessChannelArtDataList(hImageObject, pofiTxObjList);
		}
	}
    else if (tAvailableImages == CHANNEL_ART_AVAILABLE_IMAGE_ALBUM)
    {
    	SMSAPI_RETURN_CODE_ENUM eRes =
		CHANNEL_ART.eImage(hChannelArtObj,
						   CHANNEL_ART_IMAGETYPE_ALBUM,
						   &hImageObject,
						   NULL);

		if (eRes != SMSAPI_RETURN_CODE_SUCCESS) {
			ETG_TRACE_ERR(("cb_vChannelArtAccessCallback: failed"));
			return;}
		ETG_TRACE_USR4(("Sending Album Art Image"));
		/* Extract channel art info from image object */
		fc_sxm_tclChannelArtData::vProcessAlbumArtData(hImageObject, pofiTxObj);
    }
    ETG_TRACE_USR4(("rcb_vChannelArtAccessCallback() Entered"));
}

/*********************************************************************
 *
 *FUNCTION:     cb_vDecoderChannelAccessCallback
 *
 *DESCRIPTION:  decoder callback
 *             
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
static tVoid cb_vDecoderChannelAccessCallback(
    DECODER_OBJECT hDecoderObject, 
    CHANNEL_OBJECT hChannelObject, 
    void* pvArg)
{
    (tVoid) hDecoderObject; /* TO REMOVE LINT WARNINGS */

    ETG_TRACE_USR4(("cb_vDecoderChannelAccessCallback"));

    midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult *pofiTxObj= static_cast <midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult *> (pvArg);
    CHANNEL_ART_OBJECT hChannelArtObj, hAlbumArtObj;

	ETG_TRACE_USR4(("midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult"));
	/* Extract channel art handle from channel object */
	hChannelArtObj = CHANNEL.hArt(hChannelObject);
	/* Extract album art handle from channel object */
	CD_OBJECT hCDO = CHANNEL.hCDO(hChannelObject);
	if(CD_INVALID_OBJECT == hCDO){
		ETG_TRACE_ERR(("Failed to get channel art object from channel object"));
		ETG_TRACE_ERR(("Error code - %d", CHANNEL_ART.eErrorCode(fc_sxm_tclChannelartApp::instance()->getServiceObject())));
		return;
	}
	hAlbumArtObj = CDO.hArt(hCDO);

	if (!(fc_sxm_tclChannelArtData::instance()->bGetChanArtListState())){		
		if(midw_ext_fi_tcl_e8_ChnGraphicsTypes::FI_EN_CHANNEL_ART_AVAILABLE_IMAGE_LOGO & (pofiTxObj->ChannelGraphicsType))
		{
			ETG_TRACE_USR4(("(pofiTxObj->ChannelGraphicsType).enType - %d", (pofiTxObj->ChannelGraphicsType)));
			fc_sxm_tclChannelArtData::vGetChanArtInfoAccess(hChannelArtObj, pvArg);
		}
	}
	else{		
		midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult *pofiTxObjList= static_cast <midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult *> (pvArg);
		if(midw_ext_fi_tcl_e8_ChnGraphicsTypes::FI_EN_CHANNEL_ART_AVAILABLE_IMAGE_LOGO & (pofiTxObjList->ChannelGraphicsType))
		{
			ETG_TRACE_USR4(("(pofiTxObj->ChannelGraphicsType).enType - %d", (pofiTxObj->ChannelGraphicsType)));
			fc_sxm_tclChannelArtData::vGetChanArtInfoAccess(hChannelArtObj, pvArg);
		}
	}
	if(midw_ext_fi_tcl_e8_ChnGraphicsTypes::FI_EN_CHANNEL_ART_AVAILABLE_IMAGE_ALBUM & (pofiTxObj->ChannelGraphicsType))
	{
		ETG_TRACE_USR4(("(pofiTxObj->ChannelGraphicsType).enType - %d", (pofiTxObj->ChannelGraphicsType)));

		fc_sxm_tclChannelArtData::vGetChanArtInfoAccess(hAlbumArtObj, pvArg);
	}
}

/*********************************************************************
 *
 *FUNCTION:     vProcess
 *
 *DESCRIPTION:  handle channel art method start
 *             
 *PARAMETER:    prMsg
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
tVoid fc_sxm_tclChannelArtData::vProcess(
    fc_sxm_trMsgChannelartMStartGetChannelArt const * prMsg)
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelArtData::vProcess(fc_sxm_trMsgChannelartMStartGetChannelArt)"));
    ETG_TRACE_USR4(("((prMsg)->oFiMsg).SID - %d", ((prMsg)->oFiMsg).SID));

    vSetChanArtListState(FALSE);

   /* Save copy of method request data */
	midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult ofiTxObj;
	ofiTxObj.SID=(prMsg->oFiMsg).SID;
	ofiTxObj.ImageDataSize=0;
	(ofiTxObj.ChannelGraphicsType) = ((prMsg->oFiMsg).ChannelGraphicsType);

    if(_bChannelArtServiceReady)
    {
    	ETG_TRACE_USR4(("_bChannelArtServiceReady"));
		/* Get decoder object from audio app class */
		DECODER_OBJECT hDecoderObject = fc_sxm_tclAudioApp::instance()->oGetDecoderObject();

		if(hDecoderObject != DECODER_INVALID_OBJECT){
			//to get channel ID from SID
			CHANNEL_ID tChannelId = DECODER.tGetChannelId(hDecoderObject, ((prMsg)->oFiMsg).SID);

			/* Get associated Channel Object */
			/*Use the respective art event provided by CHANNEL object*/
			vAccessChannelArtObject(hDecoderObject, tChannelId, ofiTxObj);
		}
		else{
			ETG_TRACE_ERR(("Error code - %d", CHANNEL_ART.eErrorCode(fc_sxm_tclChannelartApp::instance()->getServiceObject())));
		}
	}
    else{
    	ETG_TRACE_ERR(("Error code - %d", CHANNEL_ART.eErrorCode(fc_sxm_tclChannelartApp::instance()->getServiceObject())));
    }
	/* Sending method result */
    fc_sxm_tclChannelartService::instance()->enSendFiMessage(prMsg->rAdressing, ofiTxObj);
}

/*********************************************************************
 *
 *FUNCTION:     vProcess
 *
 *DESCRIPTION:  handle channel art method start
 *
 *PARAMETER:    prMsg
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
tVoid fc_sxm_tclChannelArtData::vProcess(
		fc_sxm_trMsgChannelartMStartGetChannelArtList const * prMsg)
{
	ETG_TRACE_USR4(("fc_sxm_trMsgChannelartMStartGetChannelArtList"));
	midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult ofiTxObj;
	ofiTxObj.ChannelGraphicsType = (prMsg->oFiMsg).ChannelGraphicsType;
	vSetChanArtListState(TRUE);

	vector<tU16, allocator<tU16> >::const_iterator cii;
	if(_bChannelArtServiceReady)
	{
		ETG_TRACE_USR4(("_bChannelArtServiceReady"));
		for (cii = (prMsg->oFiMsg).ListOfSID.begin(); cii != (prMsg->oFiMsg).ListOfSID.end(); cii++)
		{
			ETG_TRACE_USR4(("SID - %d", *cii));
			_u16SID = *cii;
			/* Get decoder object from audio app class */
			DECODER_OBJECT hDecoderObject = fc_sxm_tclAudioApp::instance()->oGetDecoderObject();

			if(hDecoderObject != DECODER_INVALID_OBJECT){
				CHANNEL_ID tChannelId = DECODER.tGetChannelId(hDecoderObject, *cii);

				/* Get associated Channel Object */
				/*Use the respective art event provided by CHANNEL object*/
				vAccessChannelArtListObject(hDecoderObject, tChannelId, ofiTxObj);}
		}
	}
	else
	{
		ETG_TRACE_ERR(("Error code - %d", CHANNEL_ART.eErrorCode(fc_sxm_tclChannelartApp::instance()->getServiceObject())));
	}
	/* Sending method result */
    fc_sxm_tclChannelartService::instance()->enSendFiMessage(prMsg->rAdressing, ofiTxObj);
}

/*********************************************************************
 *
 *FUNCTION:     vProcessChannelArtData
 *
 *DESCRIPTION:  Handling image data and method result
 *             
 *PARAMETER:    IMAGE_OBJECT
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
tVoid fc_sxm_tclChannelArtData::vProcessChannelArtData(IMAGE_OBJECT hImageObject,
                                                   midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult *pofiTxObj)
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelArtData::vProcessChannelArtData()"));

    size_t ptSize = 0;
	STRING_OBJECT hFilePath;
	// Get path
    hFilePath = IMAGE.hFileName(hImageObject);
    if (hFilePath == STRING_INVALID_OBJECT)
    {
    	ETG_TRACE_ERR(("Not able to get the file name"));
        return;
    }
    string sFilePath = "";
    fc_sxm_vCopySmsString2Stl(hFilePath, sFilePath);

    OSAL_FILE_STRUCT *psImageFile = OSAL.psFopen(sFilePath.c_str(), "rb");
    if (psImageFile == NULL)
    {
    	ETG_TRACE_ERR(("Failed to open the File"));
    	return;
    }
	// get the file size in bytes, which is same as image size
    if(TRUE == OSAL.bFileSystemGetFileSize(psImageFile, &ptSize))
    {
        tU8* pu8Buffer = OSAL_NEW tU8[((sizeof(tU8))* ptSize)];
        if(NULL != pu8Buffer){
            /* Copy image data */
			size_t tBytesRead = OSAL.tFread(pu8Buffer, sizeof( tU8 ),ptSize, psImageFile);
			if (tBytesRead != ptSize )
			{
				ETG_TRACE_USR4(("failed to read data correctly"));
			}
            else
            {
            	try{
                pofiTxObj->ImageDataSize = (tU32)ptSize;
                pofiTxObj->u8ImageData = vector<tU8, allocator<tU8> >(pu8Buffer,pu8Buffer+ptSize);
				ETG_TRACE_USR4(("Channel Art copied to fi"));
            	}

            	catch(...){

            		ETG_TRACE_ERR(("Bad Allocation"));
            	}

            }
            OSAL_DELETE[] pu8Buffer;
        }
        else
        {
            ETG_TRACE_ERR(("Failed to create memory to copy image data"));
        }
    }
    OSAL.iFclose(psImageFile);
}

/*********************************************************************
 *
 *FUNCTION:     vProcessChannelArtData
 *
 *DESCRIPTION:  Handling image data and method result
 *
 *PARAMETER:    IMAGE_OBJECT
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
tVoid fc_sxm_tclChannelArtData::vProcessChannelArtDataList(IMAGE_OBJECT hImageObject,
													midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult *pofiTxObj) const
{
   ETG_TRACE_USR4(("fc_sxm_tclChannelArtData::vProcessChannelArtData()"));

   size_t ptSize = 0;
   STRING_OBJECT hFilePath;
   // Get path
   hFilePath = IMAGE.hFileName(hImageObject);
   if (hFilePath == STRING_INVALID_OBJECT)
   {
      ETG_TRACE_ERR(("Not able to get the file name"));
      return;
   }
   string sFilePath = "";
   fc_sxm_vCopySmsString2Stl(hFilePath, sFilePath);

   OSAL_FILE_STRUCT *psImageFile = OSAL.psFopen(sFilePath.c_str(), "rb");
   if (psImageFile == NULL)
   {
      ETG_TRACE_ERR(("Failed to open the File"));
      return;
   }
   // get the file size in bytes, which is same as image size
   if (TRUE == OSAL.bFileSystemGetFileSize(psImageFile, &ptSize))
   {
      tU8* pu8Buffer = OSAL_NEW tU8[((sizeof(tU8)) * ptSize)];
               if(NULL != pu8Buffer)
               {
                  /* Copy image data */
                  size_t tBytesRead = OSAL.tFread(pu8Buffer, sizeof( tU8 ),ptSize, psImageFile);
                  if (tBytesRead != ptSize )
                  {
                     ETG_TRACE_USR4(("failed to read data correctly"));
                  }
                  else
                  {
                     midw_ext_fi_tcl_ImageData tImageData;
                     tImageData.SID = _u16SID;
                     tImageData.ImageDataSize = (tU32)ptSize;
                     try {
                    	 tImageData.ImageData = vector<tU8, allocator<tU8> >(pu8Buffer,pu8Buffer+ptSize);
                    	 (pofiTxObj->ImageDataList).push_back(tImageData);
                    	 ETG_TRACE_USR4(("Channel Art copied to fi"));
                     	 }
                     catch(...) {
                    	 ETG_TRACE_ERR(("Bad allocation"));
                     }


                  }
                  OSAL_DELETE[] pu8Buffer;
               }
               else
               {
                  ETG_TRACE_ERR(("Failed to create memory to copy image data"));
               }
            }
   OSAL.iFclose(psImageFile);
}

/*********************************************************************
 *
 *FUNCTION:     vProcessAlbumArtData
 *
 *DESCRIPTION:  Handling image data and method result
 *
 *PARAMETER:    IMAGE_OBJECT
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
tVoid fc_sxm_tclChannelArtData::vProcessAlbumArtData(IMAGE_OBJECT hImageObject,
                                                   midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult *pofiTxObj)
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelArtData::vProcessAlbumArtData()"));

    size_t ptSize = 0;
 	 STRING_OBJECT hFilePath;
	// Get path
    hFilePath = IMAGE.hFileName(hImageObject);
    if (hFilePath == STRING_INVALID_OBJECT)
    {
    	ETG_TRACE_ERR(("Not able to get the file name"));
        return;
    }
    string sFilePath = "";
    fc_sxm_vCopySmsString2Stl(hFilePath, sFilePath);
    OSAL_FILE_STRUCT *psImageFile = OSAL.psFopen(sFilePath.c_str(), "rb");
    if (psImageFile == NULL)
    {
    	ETG_TRACE_ERR(("Failed to open the File"));
    	return;
    }
	// get the file size in bytes, which is same as image size
    if(TRUE == OSAL.bFileSystemGetFileSize(psImageFile, &ptSize))
    {
        tU8* pu8Buffer = OSAL_NEW tU8[((sizeof(tU8))* ptSize)];
        if(NULL != pu8Buffer)
        {
           /* Copy image data */
           size_t tBytesRead = OSAL.tFread(pu8Buffer, sizeof( tU8 ),ptSize, psImageFile);
           if (tBytesRead != ptSize )
           {
              ETG_TRACE_USR4(("failed to read data correctly"));
           }
           else
           {
            	try{
               pofiTxObj->AlbumImageSize = (tU32)ptSize;
               pofiTxObj->AlbumImageData = vector<tU8, allocator<tU8> >(pu8Buffer,pu8Buffer+ptSize);
               ETG_TRACE_USR4(("Album Art copied to fi"));
            	}
            	catch(...)
            	{
            		ETG_TRACE_ERR(("Bad allocation"));
            	}

            }
            OSAL_DELETE[] pu8Buffer;
        }
        else
        {
            ETG_TRACE_ERR(("Failed to create memory to copy image data"));
        }
    }

    OSAL.iFclose(psImageFile);
}

/*********************************************************************
 *
 *FUNCTION:     vSetChannelArtServiceState
 *
 *DESCRIPTION:  TRUE==service suscribed
                FALSE==service not subscribed
 *             
 *PARAMETER:    tBool bServiceState
 *
 *RETURNVALUE:  None
 *
 ********************************************************************/
tVoid fc_sxm_tclChannelArtData::vSetChannelArtServiceState(tBool bServiceState)
{
    _bChannelArtServiceReady = bServiceState;
}

tVoid fc_sxm_tclChannelArtData::vGetChanArtInfoAccess(CHANNEL_ART_OBJECT &hChannelArtObj, void *pvArg)
{
	if(CHANNEL_ART_INVALID_OBJECT != hChannelArtObj)
	{
		/*Get the Access to Channel Art Information in the provided callback function*/
		SMSAPI_RETURN_CODE_ENUM ret_enum = CHANNEL_ART.eUseArt(hChannelArtObj,
															   cb_vChannelArtAccessCallback,
															   pvArg);
		if(SMSAPI_RETURN_CODE_SUCCESS != ret_enum)
		{
			ETG_TRACE_ERR(("Failed to register for channel art access callback. ret_enum - %d", ret_enum));
		}
	}
	else{
		ETG_TRACE_ERR(("Failed to get channel art object from channel object"));
		ETG_TRACE_ERR(("Error code - %d", CHANNEL_ART.eErrorCode(fc_sxm_tclChannelartApp::instance()->getServiceObject())));
	}
}

tVoid fc_sxm_tclChannelArtData::vAccessChannelArtObject(DECODER_OBJECT &hDecoderObject, CHANNEL_ID &tChannelId, midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodResult &ofiTxObj)
{
	if(tChannelId != CHANNEL_INVALID_ID)
	{
		SMSAPI_RETURN_CODE_ENUM ret_enum =
			DECODER.eUseChannel(hDecoderObject,
								tChannelId,
								cb_vDecoderChannelAccessCallback,
								&ofiTxObj);
		if (SMSAPI_RETURN_CODE_SUCCESS != ret_enum){
			ETG_TRACE_ERR(("Failed to register for channel art access callback. ret_enum - %d", ret_enum));
		}
	}
	else{
		ETG_TRACE_ERR(("Error code - %d", CHANNEL_ART.eErrorCode(fc_sxm_tclChannelartApp::instance()->getServiceObject())));
	}
}

tVoid fc_sxm_tclChannelArtData::vAccessChannelArtListObject(DECODER_OBJECT &hDecoderObject, CHANNEL_ID &tChannelId, midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult &ofiTxObj)
{
	if(tChannelId != CHANNEL_INVALID_ID)
	{
		SMSAPI_RETURN_CODE_ENUM ret_enum =
			DECODER.eUseChannel(hDecoderObject,
								tChannelId,
								cb_vDecoderChannelAccessCallback,
								&ofiTxObj);
		if (SMSAPI_RETURN_CODE_SUCCESS != ret_enum){
			ETG_TRACE_ERR(("Failed to register for channel art access callback. ret_enum - %d", ret_enum));
		}
	}
	else{
		ETG_TRACE_ERR(("Error code - %d", CHANNEL_ART.eErrorCode(fc_sxm_tclChannelartApp::instance()->getServiceObject())));
	}
}

tVoid fc_sxm_tclChannelArtData::vSetChanArtListState(tBool bSetChanArtListState)
{
	_bGetChannelArtList = bSetChanArtListState;
}
