/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_channelart_app.h
* @brief       Application handler implementation for Channel Art services.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef _FC_SXM_TCL_CHANNELART_APP_H_
#define _FC_SXM_TCL_CHANNELART_APP_H_

#include "fc_sxm_sms.h"
#include "fc_sxm_channelart_fi.h"
#include "fc_sxm_tcl_data_app.h"


#define DATASERVICE_CHANNELART_DSI_ID 311


/* message to post from SMS thread to channel art thread */
struct fc_sxm_trMsgDecoderEventChannelAccessCallback: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Channelart, 103);
    CHANNEL_OBJECT hChannel;
};

// method-start from cca-service
struct fc_sxm_trMsgChannelartMStartGetChannelArt: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Channelart, 200);
    tU16 SID;
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart oFiMsg;

};

// method-start from cca-service
struct fc_sxm_trMsgChannelartMStartGetChannelArtList: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Channelart, 201);
    tU16 SID;
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart oFiMsg;

};



/*
  the channelart-app class
*/
class fc_sxm_tclChannelartApp : 
public fc_sxm_tclDataApp,
    public fc_sxm_tclSingleton<fc_sxm_tclChannelartApp>
    
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclChannelartApp>;

 public:
    static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Channelart;

    //Destructor
    virtual ~fc_sxm_tclChannelartApp();


    //Initialize the channelart service
    virtual tVoid vInitialize(tVoid);

    //DeInitialize the channelart service
    virtual tVoid vDeInitialize(tVoid);

    // dispatch thread-messages specific for channelart-app
    tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

CHANNEL_ART_SERVICE_OBJECT getServiceObject(tVoid){ return (_hChannelart); }

 protected:
    virtual tVoid vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState);
    SXM_SMS_DATASRV_ACCESS(CHANNEL_ART, _hChannelart);

    virtual tBool bResetProductState(){return FALSE;};

    // commands From CCA-Thread:
    //Start the service (Mandatory, dispatched by Base-Class)
    virtual tVoid vStartSmsService();

 private:



    // ttfis-cmds

    virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);

    virtual tVoid vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg);


    virtual tBool bEnableDataProducts() const;

    virtual DATA_PRODUCT_STATE_ENUM enGetDataProductState(DATASERVICE_MGR_OBJECT hDataService) const;

    virtual DATA_PRODUCT_STATE_ENUM enGetChannelArtProductState(DATASERVICE_MGR_OBJECT hDataService) const;

    virtual DATA_PRODUCT_STATE_ENUM enGetAlbumArtProductState(DATASERVICE_MGR_OBJECT hDataService) const;

    virtual tVoid vDisableDataProducts();

    // messages specific for channelart-app go from here

 private:

    //Constructor
    fc_sxm_tclChannelartApp();

    CHANNEL_ART_SERVICE_OBJECT _hChannelart;
	
   
    
};

#endif //_FC_SXM_TCL_CHANNELART_APP_H_
