/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_canadian_fuel_dsrl.h
* @brief       Defines the canadian fuel DSRL class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_CANADIAN_FUEL_DSRL_H_
#define _FC_SXM_TCL_CANADIAN_FUEL_DSRL_H_

#include "fc_sxm_tcl_base_dsrl.h"
#include "fc_sxm_canadian_fuel_types.h"

#define DEFAULT_FUELTYPE FUEL_TYPE_REGULAR




/* fuel-specific configuration of dsrl*/
struct fc_sxm_trCanadianFuelDSRLCfg:public fc_sxm_trDSRLBaseCfg
{
public:
    /* Default constructor*/
    fc_sxm_trCanadianFuelDSRLCfg():
    	enSortMethod(fc_sxm_enCanadianFuelDSRLSortMethod_NONE)
    {};
    /* Constructor uses fc_sxm_trDSRLGenericCfg*/
    fc_sxm_trCanadianFuelDSRLCfg(fc_sxm_trDSRLGenericCfg const &rGenericCfg) {
        u32Capacity=rGenericCfg.u32Capacity;
        rLocation=rGenericCfg.rLocation;
        u32Radius=rGenericCfg.u32Radius;
        enSortMethod=(fc_sxm_tenCanadianFuelDSRLSortMethod)rGenericCfg.u8SortMethod;
        rFilterCfg.enCanadianFuelType=(FUEL_TYPE_ENUM)rGenericCfg.u8FilterMethod;
        rFilterCfg.sBrand=rGenericCfg.oString;
    }

    fc_sxm_tenCanadianFuelDSRLSortMethod enSortMethod;
    fc_sxm_trCanadianFuelDSRLFilterCfg rFilterCfg;
    virtual tVoid vPrintSpecific() const;

};

/* Fuel DSRL handling class */
class fc_sxm_tclCanadianFuelDSRL :
   public fc_sxm_tclConfigDSRL<fc_sxm_trCanadianFuelDSRLCfg>
{

public:
   /* Constuctor*/
   fc_sxm_tclCanadianFuelDSRL(fc_sxm_tenDSRLType enDsrlType);

   /*Destructor*/
   virtual ~fc_sxm_tclCanadianFuelDSRL();

   /*Update notification when the DSRL is ready and iterated*/
   virtual tVoid vOnDSRLUpdate(tVoid);

   virtual tBool bHandleFilterCallback(DSRL_OBJECT hDSRL,
                                       DSRL_ENTRY_OBJECT hEntry);

   virtual tS16 s16HandleSortCallback(DSRL_OBJECT hDSRL,
                                      DSRL_ENTRY_OBJECT hEntry1,
                                      DSRL_ENTRY_OBJECT hEntry2);

   virtual tBool bHandleIterateCallback(DSRL_OBJECT hDSRL,
                                        DSRL_ENTRY_ID tEntryID,
                                        DSRL_ENTRY_STATUS_ENUM eStatus,
                                        DSRL_ENTRY_OBJECT hEntryObject);
   virtual tVoid vHandleDsrlEntryInvalid(DSRL_ENTRY_ID tEntryID);
   

private:

   /*Get Amenitys*/
   tVoid vGetAmenity(FUEL_STATION_OBJECT hStation, string &sAmenity) const;
   tVoid vGetAllAmenity(FUEL_STATION_AMENITY_ENUM eAmenity, string &sAmenity) const;
  /*Get fuel Amenitys as enum type*/ 
   tVoid vGetAmenityEnum(FUEL_STATION_OBJECT hStation, vector<midw_ext_fi_tcl_e8_CanFuelStationAmenity> &hAmenity) const;

   /* patch a specific dsrl-entry according to rTestModification */
   tVoid vApplyTestModification(DSRL_ENTRY_ID tEntryID, fc_sxm_trCanadianFuelListEntry &rListEntry, DSRL_ENTRY_STATUS_ENUM &eStatus);

   /*Store All Brand Name*/
   static set<string> _poBrandNameList;
   /*Flag for New Brand Name found*/
   volatile tBool _u8BrandUpdateStatus; 

};

#endif //_FC_SXM_TCL_CANADIAN_FUEL_DSRL_H_
