/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_canadian_fuel_types.h
* @brief       Defines canadian fuel type and sort method.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef FC_SXM_CANADIAN_FUEL_TYPES_H
#define FC_SXM_CANADIAN_FUEL_TYPES_H

#include "fc_sxm_sms.h"
#include "fc_sxm_tcl_base_dsrl.h"

// SMS-default sort-method must have number 0
typedef enum
{
   fc_sxm_enCanadianFuelDSRLSortMethod_NONE,
   fc_sxm_enCanadianFuelDSRLSortMethod_PRICE,
   fc_sxm_enCanadianFuelDSRLSortMethod_DISTANCE,
   fc_sxm_enCanadianFuelDSRLSortMethod_BRANDNAME,
   fc_sxm_enCanadianFuelDSRLSortMethod_FIRST_SAVED_FIRST

} fc_sxm_tenCanadianFuelDSRLSortMethod;


// filter-configuration must provide operator!=
struct fc_sxm_trCanadianFuelDSRLFilterCfg {
    FUEL_TYPE_ENUM enCanadianFuelType;
    string  sBrand;

    fc_sxm_trCanadianFuelDSRLFilterCfg() :
       enCanadianFuelType(FUEL_TYPE_UNKNOWN),
       sBrand("")
    {}
    // to check if filter has chanded, configuration has to provice operator!= 
    bool operator!=(fc_sxm_trCanadianFuelDSRLFilterCfg const &b) const {
        SXM_RET_1_IF_NEQ(enCanadianFuelType);
        SXM_RET_1_IF_NEQ(sBrand);
        return false;
    }

};




#endif
