/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_surface_data.h
* @brief       Declaration of Surface Features & Pressures – information about surface features like,
*              atmospheric fronts areas with similar temperature and fields of high or low pressure.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_SURFACE_DATA_H_
#define _FC_SXM_TCL_AGW_SURFACE_DATA_H_

#include "fc_sxm_tcl_agw_shapes.h"
struct fc_sxm_tclShapeProductSurfaceData:public fc_sxm_tclShapeProductBase {
public:
    fc_sxm_tclShapeProductSurfaceData():
        fc_sxm_tclShapeProductBase(AGW_PRODUCT_TYPE_SURFACE_FEATURES)
    {};
    virtual vector<midw_ext_fi_tcl_SXMShape> &roGetShapesVector() 
    {
        return oMResSurfaceData.Shapes;
    };
    
    virtual tVoid vNotify();
    virtual tVoid vEmit(fc_sxm_trAdressing rAdressing);
        
    virtual tBool bAddShape(AGW_SHAPE_OBJECT hAgwShape, midw_ext_fi_tcl_SXMShape &roShapeObj);

    private:
    void vGetFront(AGW_SHAPE_OBJECT hAgwShape, midw_ext_fi_tcl_SXMShape &roShapeObj) const;
    void vGetPressureCenter(AGW_SHAPE_OBJECT hAgwShape, midw_ext_fi_tcl_SXMShape &roShapeObj) const;
	void vGetIsoBar(AGW_SHAPE_OBJECT hAgwShape, midw_ext_fi_tcl_SXMShape &roShapeObj) const;
    public:
    midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodResult oMResSurfaceData;
};

#endif
