/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_storm_track_data.h
* @brief       Declaration of the AGW track data.
*              The Storm Track product describes tropical storms in terms of their
*              historical and forecast positions including their wind radii fields.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_STORM_TRACK_DATA_H_
#define _FC_SXM_TCL_AGW_STORM_TRACK_DATA_H_

#include "fc_sxm_tcl_agw_shapes.h"
struct fc_sxm_tclShapeProductStormTrackData:public fc_sxm_tclShapeProductBase {
public:
    fc_sxm_tclShapeProductStormTrackData():
        fc_sxm_tclShapeProductBase(AGW_PRODUCT_TYPE_STORM_TRACK)
    {};
    virtual vector<midw_ext_fi_tcl_SXMShape> &roGetShapesVector() 
    {
        return oMResStormTrackData.Shapes;
    };
    
    virtual tVoid vNotify();
    virtual tVoid vEmit(fc_sxm_trAdressing rAdressing);
	virtual tVoid vClearOutput();
        
    virtual tBool bAddShape(AGW_SHAPE_OBJECT hAgwShape, midw_ext_fi_tcl_SXMShape &roShapeObj);

	static BOOLEAN bFtchAgwWindRadiiObjIterator(AGW_SHAPE_OBJECT hAgwStormPos,void* pvArg);
	static BOOLEAN bFtchAgwStmTrkPosObjIterator(AGW_SHAPE_OBJECT hAgwStormPos,void* pvArg);

    private:
   	//sms v16.0 onwards
	tBool vGetStormTrack(AGW_SHAPE_OBJECT hAgwShape, midw_ext_fi_tcl_SXMShape &roShapeObj) const;
    public:
    midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodResult oMResStormTrackData;

};




#endif
