/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_storm_attr_data.cpp
* @brief       Implementation of handling AGW storm product attributes
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_sms_util.h"
#include "fc_sxm_tcl_agw_app.h"
#include "fc_sxm_tcl_agw_storm_attr_data.h"
#include "fc_sxm_service_sxm_agw.h"
#include "fc_sxm_tcl_sxmapp_manager.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_AGW_DSRL
#include "trcGenProj/Header/fc_sxm_tcl_agw_storm_attr_data.cpp.trc.h"
#endif


tVoid fc_sxm_tclShapeProductStormAttrData::vNotify() {
    fc_sxm_tcl_trAgwPropertyStormAttrDataStatus oStormAttrDataStatus;
	midw_ext_fi_tcl_SXMShape oShapeObj;
	//midw_ext_fi_tcl_SXMShapeTypeStormAttributes * tempStormAttr --only for testing

    oStormAttrDataStatus.oFiMsg.UpdateCounter=u32UpdateCounter;
	
	// preparing the FI-message as soon as the read-dsrl is done
	// passing the custody of set-pointers to FI
	for(set<midw_ext_fi_tcl_SXMShapeTypeStormAttributes*, trCompareStormAttribute>::iterator iter= _setStormAttributes.begin();
		iter != _setStormAttributes.end();
		++iter) {
		oShapeObj.ShapeTypeType.enType =  midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMATTRIBUTES;
		oShapeObj.poShapeTypeData = *iter;
#if 0
		//only for testing purpose	
		tempStormAttr = *iter;
		ETG_TRACE_USR4(("AGW_STORM_ATTRIBUTES::Storm Attribute Type(%d)",
		 ETG_CENUM(fc_sxm_tclShapeProductStormAttrData::tenStormAttrType, trCompareStormAttribute::enGetStormAttrType(*tempStormAttr))));
		ETG_TRACE_USR4(("AGW_STORM_ATTRIBUTES.eEchoTop() is  %d", tempStormAttr->EchoTopHeight.s32Value));
		ETG_TRACE_USR4(("AGW_STORM_ATTRIBUTES.hStormID() is %s", tempStormAttr->StormUniqueId.szValue));
#endif
		oMResStormAttrData.Shapes.push_back(oShapeObj);
	}

    ETG_TRACE_USR4(("fc_sxm_tclShapeProductStormAttrData::vNotify() UpdateCounter = %d", u32UpdateCounter));
    fc_sxm_tclAgwProperties::instance()->oStormAttrDataStatus.vSetAndNotify(oStormAttrDataStatus);
};

tVoid fc_sxm_tclShapeProductStormAttrData::vEmit(fc_sxm_trAdressing rAdressing) {	
	oMResStormAttrData.UpdateCounter=u32UpdateCounter;
	ETG_TRACE_USR4(("fc_sxm_tclShapeProductStormAttrData::vEmit() u32UpdateCounter = %d", u32UpdateCounter));
	fc_sxm_tclAgwService::instance()->enSendFiMessage(rAdressing, oMResStormAttrData);     
}; 

tVoid fc_sxm_tclShapeProductStormAttrData::vClearOutput() {
  
     _setStormAttributes.clear();
	ETG_TRACE_USR4(("*************************CLEAR***************************************"));
    // call base-class
    fc_sxm_tclShapeProductBase::vClearOutput();
}


/*
  overwrite vAddShape like last time
*/
tVoid fc_sxm_tclShapeProductStormAttrData::vAddShape(AGW_SHAPE_OBJECT hAgwShape)
{
	ETG_TRACE_USR4(("fc_sxm_tclShapeProductStormAttrData::bAddShape() -- Enter"));
  	//data-structure to send via fi-message --end

	//populating the data-structure and posting it in fi-message

	AGW_SHAPE_TYPE_ENUM eShapeType = AGW_SHAPE.eShapeType(hAgwShape);

	switch(eShapeType)
    {
        case AGW_SHAPE_TYPE_STORM_ATTRIBUTES:
			ETG_TRACE_USR4(("fc_sxm_tclShapeProductStormAttrData::bAddShape() -- AGW_SHAPE_TYPE_STORM_ATTRIBUTES"));
            vGetStormAttrbiutes(hAgwShape);
            break;		
		default:
            // no specific shape has been added, so remove generic shape.
            break;
	}

	ETG_TRACE_USR4(("fc_sxm_tclShapeProductStormAttrData::bAddShape() -- Exit"));
}


//lint -save -e429
void fc_sxm_tclShapeProductStormAttrData::vGetStormAttrbiutes(AGW_SHAPE_OBJECT hAgwShape) {
    
	ETG_TRACE_USR4(("fc_sxm_tclShapeProductStormAttrData::vGetStormAttrbiutes -- Enter"));
	

    midw_ext_fi_tcl_SXMShapeTypeStormAttributes *poStormAttr = OSAL_NEW midw_ext_fi_tcl_SXMShapeTypeStormAttributes;
	if (OSAL_NULL == poStormAttr)
	{
		return;
	}
   
		
    if((AGW_SHAPE.eShapeType (hAgwShape))== AGW_SHAPE_TYPE_STORM_ATTRIBUTES) {
		ETG_TRACE_USR4(("#AGW Shape Type is %s", "AGW_SHAPE_TYPE_STORM_ATTRIBUTES"));
    }

	AGW_STORM_ATTRIBUTES_OBJECT hStormAttr = AGW_SHAPE.hStormAttributes(hAgwShape);

    poStormAttr->IssueTime.Time = (tS32)(AGW_SHAPE.tTimeStamp(hAgwShape));
	ETG_TRACE_USR4(( "#AGW Storm attribute issue time is %d", poStormAttr->IssueTime.Time));

    poStormAttr->ObservationTime.Time = (tS32)(AGW_STORM_ATTRIBUTES.tObservationTime(hStormAttr));
	ETG_TRACE_USR4(("#AGW_SHAPE_TYPE_STORM_ATTRIBUTES.tObservationTime() is  %u", poStormAttr->ObservationTime.Time));

	STRING_OBJECT hStormId = AGW_STORM_ATTRIBUTES.hStormID(hStormAttr);
   fc_sxm_vCopySmsString2Fi(hStormId, poStormAttr->StormUniqueId);
	ETG_TRACE_USR4(("#AGW_STORM_ATTRIBUTES.hStormID() is %s", poStormAttr->StormUniqueId.szValue));

	OSAL_FIXED_OBJECT hDirection = OSAL_FIXED_INVALID_OBJECT;



	OSAL_FIXED_OBJECT_DATA atDirectionData[OSAL_FIXED_OBJECT_SIZE];
   hDirection = OSAL_FIXED.hCreateInMemory(0, 0, atDirectionData);
	if (SMSAPI_RETURN_CODE_NOT_FOUND == AGW_STORM_ATTRIBUTES.eDirection(hStormAttr, hDirection)) {
      poStormAttr->MovementDirection.s16Value = -1;
   } 
   else {
	   poStormAttr->MovementDirection.s16Value = (tS16)fc_sxm_fFixed2Float(hDirection);
   }
	ETG_TRACE_USR4(("#AGW_STORM_ATTRIBUTES.eDirection() is  %d", poStormAttr->MovementDirection.s16Value));

 	OSAL_FIXED_OBJECT hSpeed = OSAL_FIXED_INVALID_OBJECT;
	OSAL_FIXED_OBJECT_DATA atSpeed[OSAL_FIXED_OBJECT_SIZE];
   hSpeed = OSAL_FIXED.hCreateInMemory(0, 0, atSpeed);
	if (SMSAPI_RETURN_CODE_NOT_FOUND == AGW_STORM_ATTRIBUTES.eSpeed(hStormAttr, hSpeed)) {
      poStormAttr->MovementSpeed.s16Value = -1;
   } 
   else {
	   poStormAttr->MovementSpeed.s16Value = (tS16) fc_sxm_fFixed2Float(hSpeed);
   }

	ETG_TRACE_USR4(("#AGW_STORM_ATTRIBUTES.eSpeed() is  %d", poStormAttr->MovementSpeed.s16Value));

   OSAL_FIXED_OBJECT hEchoTop = OSAL_FIXED_INVALID_OBJECT;
	OSAL_FIXED_OBJECT_DATA atEchoTop[OSAL_FIXED_OBJECT_SIZE];
   hEchoTop = OSAL_FIXED.hCreateInMemory(0, 0, atEchoTop);
	AGW_STORM_ATTRIBUTES.eEchoTop(hStormAttr, hEchoTop);
	poStormAttr->EchoTopHeight.s32Value = (tS32)fc_sxm_fFixed2Float(hEchoTop);
	ETG_TRACE_USR4(("#AGW_STORM_ATTRIBUTES.eEchoTop() is  %d", poStormAttr->EchoTopHeight.s32Value));

	if (TRUE == AGW_STORM_ATTRIBUTES.bIsHailProbable(hStormAttr))
	{
		poStormAttr->StormType.vSetHailProbable(midw_ext_fi_tcl_b8_StormType::FI_C_U8_BIT_HAILPROBABLE);
	}
	if (TRUE == AGW_STORM_ATTRIBUTES.bIsHailPositive(hStormAttr))
	{
		poStormAttr->StormType.vSetHailPositive(midw_ext_fi_tcl_b8_StormType::FI_C_U8_BIT_HAILPOSITIVE);
	}
	if (TRUE == AGW_STORM_ATTRIBUTES.bIsMesocyclonic(hStormAttr))
	{
		poStormAttr->StormType.vSetMesocyclonic(midw_ext_fi_tcl_b8_StormType::FI_C_U8_BIT_MESOCYCLONIC);
	}
	if (TRUE == AGW_STORM_ATTRIBUTES.bIsTornadic(hStormAttr))
	{
		poStormAttr->StormType.vSetTornadic(midw_ext_fi_tcl_b8_StormType::FI_C_U8_BIT_TORNADIC);
	}

	//AGW_STORM_ATTRIBUTES.bIsHailPositive
	ETG_TRACE_USR4(("#AGW_STORM_ATTRIBUTES.bIsHailPositive is %d", AGW_STORM_ATTRIBUTES.bIsHailPositive(hStormAttr)));

	//AGW_STORM_ATTRIBUTES.bIsHailProbable
	ETG_TRACE_USR4(("#AGW_STORM_ATTRIBUTES.bIsHailProbable is %d", AGW_STORM_ATTRIBUTES.bIsHailProbable(hStormAttr)));

	//AGW_STORM_ATTRIBUTES.bIsMesocyclonic
	ETG_TRACE_USR4(("#AGW_STORM_ATTRIBUTES.bIsMesocyclonic is %d", AGW_STORM_ATTRIBUTES.bIsMesocyclonic(hStormAttr)));

	//AGW_STORM_ATTRIBUTES.bIsTornadic
	ETG_TRACE_USR4(("#AGW_STORM_ATTRIBUTES.bIsTornadic is %d", AGW_STORM_ATTRIBUTES.bIsTornadic(hStormAttr)));

	//AGW_SHAPE.un16Points
	ETG_TRACE_USR4(( "#AGW_SHAPE.un16Points is %d", AGW_SHAPE.un16Points(hAgwShape)));

    //AGW_SHAPE.eIteratePoints
   ETG_TRACE_USR4(( "Iterate for %d (lat,lon) -- START ", 1));
    vector<fc_sxm_trPoint> vecPoints;
    tU32 u32NumPoints = u32GetPoints(hAgwShape, vecPoints);
    for (tU32 i=0; i<u32NumPoints; i++) {
        fc_sxm_trPoint rPoint=vecPoints[i];

        ETG_TRACE_USR4(("Storm attribute SMS co-ordinates lat=%f, lon=%f", 
           rPoint.fLat, rPoint.fLon));

        poStormAttr->GeoPoint.Latitude.s32Value = fc_sxm_tclHelpers::fc_sxm_s32SmsDegreeFloatToNav(rPoint.fLat);
        poStormAttr->GeoPoint.Longitude.s32Value = fc_sxm_tclHelpers::fc_sxm_s32SmsDegreeFloatToNav(rPoint.fLon);

        ETG_TRACE_USR4(("Storm attribute WGS co-ordinates lat=%d, lon=%d", 
           poStormAttr->GeoPoint.Latitude.s32Value, poStormAttr->GeoPoint.Longitude.s32Value));
	}
	_setStormAttributes.insert(poStormAttr);
}
//lint -restore
