/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_shapes.cpp
* @brief       Implementation of handling AGW Shape product
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_sms_util.h"
#include "fc_sxm_tcl_agw_shapes.h"
#include "fc_sxm_tcl_agw_storm_track_data.h"
#include "fc_sxm_tcl_agw_storm_attr_data.h"
#include "fc_sxm_tcl_agw_surface_data.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_AGW_DSRL
#include "trcGenProj/Header/fc_sxm_tcl_agw_shapes.cpp.trc.h"
#endif

/*
  ####### Base-Class for all shape-Products #######
*/
fc_sxm_tclShapeProductBase::fc_sxm_tclShapeProductBase(AGW_PRODUCT_TYPE_ENUM enProductType_):
    fc_sxm_tclAgwProductBase(enProductType_)
{
    ETG_TRACE_USR4(("fc_sxm_tclShapeProductBase::CTOR %d",
                    ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType)));
    fc_sxm_tclAgwShapes::instance()->vAddProduct(this);  
}

fc_sxm_tclShapeProductBase::~fc_sxm_tclShapeProductBase() {
    ETG_TRACE_USR4(("fc_sxm_tclShapeProductBase::DTOR %d",
                    ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType)));
    fc_sxm_tclAgwShapes::instance()->vRemoveProduct(this);  
};

tVoid fc_sxm_tclShapeProductBase::vClearOutput() {
    ETG_TRACE_USR4(("fc_sxm_tclShapeProductBase::vClearOutput(%d)",
                    ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType)));
    roGetShapesVector().clear();
}


tVoid fc_sxm_tclShapeProductBase::vAddShape(AGW_SHAPE_OBJECT hAgwShape) {
    
    vector<midw_ext_fi_tcl_SXMShape> &vecShapes=roGetShapesVector();
    // add element
    tU32 u32NumShapes = (tU32)(vecShapes.size());
	vecShapes.push_back(midw_ext_fi_tcl_SXMShape());
    ETG_TRACE_USR4(("fc_sxm_tclShapeProductBase::vAddShape(%d) u32NumShapes=%u",
                    ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType),
                    u32NumShapes));
    midw_ext_fi_tcl_SXMShape &roShapeObj=vecShapes[u32NumShapes];
    if (!bAddShape(hAgwShape, roShapeObj)) {
        ETG_TRACE_USR4(("fc_sxm_tclShapeProductBase::vAddShape(%d) FAILED",
                        ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType)));
        vecShapes.resize(u32NumShapes);
    }
}

static BOOLEAN bIteratePointsCallback(
    OSAL_FIXED_OBJECT hLat,
    OSAL_FIXED_OBJECT hLon,
    void* pvArg
        )
{
    // peha: from where do you know that the last point of the shape is the one you searched for?
    if (OSAL_NULL != pvArg) {
        fc_sxm_trPoint rPoint;
        rPoint.fLat = fc_sxm_fFixed2Float(hLat);
        rPoint.fLon = fc_sxm_fFixed2Float(hLon);

        ((vector<fc_sxm_trPoint> *)pvArg)->push_back(rPoint);
    }
	return TRUE;		
}

tU32 fc_sxm_tclShapeProductBase::u32GetPoints(AGW_SHAPE_OBJECT hAgwShape, vector<fc_sxm_trPoint> &vecPoints) const{
    static vector<fc_sxm_trPoint> *pVecPoints;
    vecPoints.clear();
    pVecPoints=&vecPoints;
    SMSAPI_RETURN_CODE_ENUM eReturnCode= AGW_SHAPE.eIteratePoints (hAgwShape, bIteratePointsCallback,pVecPoints);
    (tVoid)eReturnCode;
    return (tU32)(vecPoints.size());
}


/*
  ####### Container-class for all shape-products #######
*/
fc_sxm_tclAgwShapes::fc_sxm_tclAgwShapes() {
    ETG_TRACE_USR4(("fc_sxm_tclAgwShapes::CTOR)"));
}

fc_sxm_tclAgwShapes::~fc_sxm_tclAgwShapes() {
    ETG_TRACE_USR4(("fc_sxm_tclAgwShapes::DTOR)"));
    SXM_FOREACH_MAP(AGW_PRODUCT_TYPE_ENUM, fc_sxm_tclShapeProductBase*, iter, _mapProducts) {
        fc_sxm_tclShapeProductBase *poProduct=iter->second;
        ETG_TRACE_USR4(("fc_sxm_tclAgwShapes::delete product %d",
                        ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, poProduct->enProductType)));
        OSAL_DELETE poProduct;
    }
    _mapProducts.clear();
}

fc_sxm_tclShapeProductBase *fc_sxm_tclAgwShapes::poGetProduct(AGW_PRODUCT_TYPE_ENUM enProductType) {
    SXM_IF_FIND_MAP(AGW_PRODUCT_TYPE_ENUM, fc_sxm_tclShapeProductBase*, iter, _mapProducts, enProductType) {
        ETG_TRACE_USR4(("fc_sxm_tclAgwShapes::poGetProduct(%d) FOUND",
                        ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType)));
        return iter->second;
    }
    ETG_TRACE_USR4(("fc_sxm_tclAgwShapes::poGetProduct(%d) NOT FOUND",
                    ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType)));
    return OSAL_NULL;
}

tVoid fc_sxm_tclAgwShapes::vEmit(AGW_PRODUCT_TYPE_ENUM enProductType,fc_sxm_trAdressing rAdressing) {
    fc_sxm_tclShapeProductBase *poProduct=poGetProduct(enProductType);
    ETG_TRACE_USR4(("fc_sxm_tclAgwShapes::vEmit(%d)",
                    ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType)));
    if (OSAL_NULL != poProduct) {
        poProduct->vEmit(rAdressing);
    }
}

tVoid fc_sxm_tclAgwShapes::vAddProduct(fc_sxm_tclShapeProductBase *poProduct) {
    ETG_TRACE_USR4(("fc_sxm_tclAgwShapes::vAddProduct(%d)",
                    ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, poProduct->enProductType)));
    
    _mapProducts[poProduct->enProductType]=poProduct;
}

tVoid fc_sxm_tclAgwShapes::vRemoveProduct(fc_sxm_tclShapeProductBase *poProduct) {
    SXM_IF_FIND_MAP(AGW_PRODUCT_TYPE_ENUM, fc_sxm_tclShapeProductBase*, iter, _mapProducts, poProduct->enProductType) {
        ETG_TRACE_USR4(("fc_sxm_tclAgwShapes::vRemoveProduct(%d) OK",
                        ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, poProduct->enProductType)));
        _mapProducts.erase(iter);
    } else {
        ETG_TRACE_USR1(("fc_sxm_tclAgwShapes::vRemoveProduct(%d) NOT FOUND",
                        ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, poProduct->enProductType)));
    }
}
