/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_products.h
* @brief       Declaration of handling different AGW Products
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_PRODUCTS_H_
#define _FC_SXM_TCL_AGW_PRODUCTS_H_

#include "fc_sxm_common.h"
// just take any data-fi
#include "fc_sxm_agw_fi.h"
#include "fc_sxm_sms.h"

/*
  Base-Class for all Products
*/
struct fc_sxm_tclAgwProductBase {
    fc_sxm_tclAgwProductBase(AGW_PRODUCT_TYPE_ENUM enProductType_);
    virtual ~fc_sxm_tclAgwProductBase();

    virtual tVoid vNotify()=0;

    virtual tVoid vSetChanged();
	
	//new function to get the bPendingChange flag
	virtual tBool bGetPendingChangeFlag(){
		return bPendingChange;
	}


    virtual tVoid vClearOutput()=0;
    virtual tBool bIsLocked() {
        return FALSE;
    }

    AGW_PRODUCT_TYPE_ENUM enProductType;
    tBool bChanged;
    tU32 u32UpdateCounter;
    /* dsrl has been iterated and we detected changes for this product while shared memory was locked
       dsrl has to be manualy iterated for this product again (only used for tiles)
    */
    tBool bPendingChange; 
    //fc_sxm_trAdressing rAdressing;


};

/*
  Container-class for all Products
*/
class fc_sxm_tclAgwProducts:
public fc_sxm_tclSingleton<fc_sxm_tclAgwProducts>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclAgwProducts>;
    friend struct fc_sxm_tclAgwProductBase;

 public:
    ~fc_sxm_tclAgwProducts();
    fc_sxm_tclAgwProductBase *poGetProduct(AGW_PRODUCT_TYPE_ENUM enProductType);

    tVoid vInit();
    tVoid vNotify();
    tVoid vClearCounters();
    virtual tVoid vSetChanged(AGW_PRODUCT_TYPE_ENUM enProductType);
    tBool bIsChanged();
    tVoid vSetFilters(AGW_SERVICE_OBJECT _hAgw);
    template<class PRODUCT>
        tVoid vAddProduct() {
        (tVoid)OSAL_NEW PRODUCT;
    }

 private:
    fc_sxm_tclAgwProducts();
    map<AGW_PRODUCT_TYPE_ENUM, fc_sxm_tclAgwProductBase*> _mapProducts;    
    tVoid vAddProduct(fc_sxm_tclAgwProductBase *poProduct);
    tVoid vRemoveProduct(fc_sxm_tclAgwProductBase *poProduct);
    
};

#endif
