/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_dsrl.h
* @brief       Declaration of the AGW DSRL functionalities and invokes SMS libraries.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_DSRL_H_
#define _FC_SXM_TCL_AGW_DSRL_H_

#include "fc_sxm_tcl_base_dsrl.h"
#include "fc_sxm_agw_types.h"
#include "fc_sxm_tcl_agw_properties.h"


// agw-specific configuration of dsrl
struct fc_sxm_trAgwDSRLCfg:public fc_sxm_trDSRLBaseCfg
{
public:
	fc_sxm_trAgwDSRLFilterCfg rFilterCfg;
	fc_sxm_tenAgwSortMethod enSortMethod;
};

class fc_sxm_tclAgwDSRL : 
   public fc_sxm_tclConfigDSRL<fc_sxm_trAgwDSRLCfg> 
{

public:
   // Constuctor
   fc_sxm_tclAgwDSRL(fc_sxm_tenDSRLType enDsrlTypee);

   //Destructor
   virtual ~fc_sxm_tclAgwDSRL();

   //Update notification when the DSRL is ready and iterated
   virtual tVoid vOnDSRLUpdate(tVoid);

   tVoid vReadDsrl();

   virtual tBool bHandleFilterCallback(DSRL_OBJECT hDSRL, 
                                       DSRL_ENTRY_OBJECT hEntry);
   
   virtual tS16 s16HandleSortCallback(DSRL_OBJECT hDSRL,
                                      DSRL_ENTRY_OBJECT hEntry1,
                                      DSRL_ENTRY_OBJECT hEntry2);
   
   virtual tBool bHandleIterateCallback(DSRL_OBJECT hDSRL, 
                                        DSRL_ENTRY_ID tEntryID,
                                        DSRL_ENTRY_STATUS_ENUM eStatus,
                                        DSRL_ENTRY_OBJECT hEntryObject);


   tBool bHandleIterateCallbackRead(DSRL_OBJECT hDSRL, 
                                    DSRL_ENTRY_ID tEntryID,
                                    DSRL_ENTRY_STATUS_ENUM eStatus,
                                    DSRL_ENTRY_OBJECT hEntryObject) const;

    private:


};

#endif //_FC_SXM_TCL_AGW_DSRL_H_
