/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_agw_types.h
* @brief       Declaration of the AGW DSRL specific sort and filter-types
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_AGW_TYPES_H
#define FC_SXM_AGW_TYPES_H

#include "fc_sxm_sms.h"

// SMS-default sort-method must have number 0
typedef enum
{
   fc_sxm_enAgwSortMethod_NONE=0,
   fc_sxm_enAgwSortMethod_PRODUCT_TYPE

} fc_sxm_tenAgwSortMethod;



// filter-configuration must provide operator!=
struct fc_sxm_trAgwDSRLFilterCfg {
    AGW_PRODUCT_TYPE_ENUM enProductType;
    // to check if filter has chanded, configuration has to provice operator!= 
    bool operator!=(fc_sxm_trAgwDSRLFilterCfg const &b) const {
        SXM_RET_1_IF_NEQ(enProductType);
        return FALSE;
    }

};




#endif
