/**
* @swcomponent fc_sxm
* @{
* @file        DatapoolTypes.h
* @brief       Defines the the data pool list element.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/
#ifndef FC_SXM_DATAPOOL_TYPES_H_
#define FC_SXM_DATAPOOL_TYPES_H_


#define FC_SXM_PERS_DATA_NUM_DATA_APP_MAX 16

#define FC_SXM_PERS_DATA_STR_LEN_MAX 64
#define FC_SXM_PERS_STOCK_DATA_STR_LEN_MAX 10

#define INITIAL_DATASET_DEF_SPORTS_LIST   \
        0x00,                                    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00

#define INIT_DEF_SET_SPORTS_LIST       \
        INITIAL_DATASET_DEF_SPORTS_LIST, \
        INITIAL_DATASET_DEF_SPORTS_LIST, \
        INITIAL_DATASET_DEF_SPORTS_LIST, \
        INITIAL_DATASET_DEF_SPORTS_LIST, \
        INITIAL_DATASET_DEF_SPORTS_LIST, \
        INITIAL_DATASET_DEF_SPORTS_LIST, \
        INITIAL_DATASET_DEF_SPORTS_LIST



#define INITIAL_DATASET_DEF_ROOT_LIST   \
        0x00, 0x00,                                   \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00

#define INIT_DEF_SET_ROOT_LIST  \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST, \
        INITIAL_DATASET_DEF_ROOT_LIST


#define INITIAL_DATASET_DEF_FAV_LIST   \
        0x00, 0x00, 0x00, 0x00,                                   \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00


//Max. 18 favorites for Sports
#define INIT_DEF_SET_FAV_LIST  \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST, \
        INITIAL_DATASET_DEF_FAV_LIST

struct dpSportListElement {                  /* Sport list element     */
    tU8 u8SportID;                           /* Sport ID               */
    char sSportName[FC_SXM_PERS_DATA_STR_LEN_MAX];                     /* Sport name             */
};


struct dpRootListElement {                  /* Root list element      */
    tU8 u8SportID;                          /* Sport ID               */
    tU32 u32AffiliateID;                    /* Affiliate ID           */
    char sAffiliateName[FC_SXM_PERS_DATA_STR_LEN_MAX];                /* Affiliate name         */
    tU8 u8Season;                           /* Affiliate season       */
};

struct dpFavoriteListElement {              /* Favorite list element  */
    tU8 u8SportID;                          /* Sport ID               */
    tU32 u32TeamID;                         /* Team ID                */
    tU32 u32LeagueID;                       /* League ID              */
    tU32 u32GDRef;                          /* Global Reference ID    */
    char sTeamName[FC_SXM_PERS_DATA_STR_LEN_MAX];                     /* Full Team name         */
    char sTeamAbrName[FC_SXM_PERS_DATA_STR_LEN_MAX];                     /* Abbreviated name         */
    char sTeamKnownName[FC_SXM_PERS_DATA_STR_LEN_MAX];                     /* Known name         */
    char sTeamNickName[FC_SXM_PERS_DATA_STR_LEN_MAX];                     /* Nick name         */
    char sSportName[FC_SXM_PERS_DATA_STR_LEN_MAX];                    /* Affiliate name         */
};


struct dpAppListElement {                  /* App list element     */
    tU32 u32LocID;                         /* Loc ID               */
};

struct dpStockListElement {                  /* Stocks list element     */
    char sName[FC_SXM_PERS_STOCK_DATA_STR_LEN_MAX];                          /* String ID               */
};

#endif /* FC_SXM_DATAPOOL_TYPES_H_ */
