/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_tts_states.h
* @brief       Declaration of TTSState and states classes
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_TTS_STATES_H_
#define _FC_SXM_TCL_TTS_STATES_H_

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "fc_sxm_trace_macros.h"
#include "fc_sxm_tcl_singleton.h"

class fc_sxm_tclTTSState
{
public:
   fc_sxm_tclTTSState();
   virtual ~fc_sxm_tclTTSState();
   virtual tVoid vDoAction() = 0;
   virtual tVoid vPrintStateChangeInfo() = 0;
   virtual tBool operator ==(const fc_sxm_tclTTSState *);
};

class fc_sxm_tclTTSStateInitial :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStateInitial>
{
public:
   virtual ~fc_sxm_tclTTSStateInitial();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStateInitial>;
   fc_sxm_tclTTSStateInitial();
};

class fc_sxm_tclTTSStatePending :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStatePending>
{
public:
   virtual ~fc_sxm_tclTTSStatePending();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStatePending>;
   fc_sxm_tclTTSStatePending();
};


class fc_sxm_tclTTSStateReady :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStateReady>
{
public:
   virtual ~fc_sxm_tclTTSStateReady();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStateReady>;
   fc_sxm_tclTTSStateReady();
};

class fc_sxm_tclTTSStatePrepared :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStatePrepared>
{
public:
   virtual ~fc_sxm_tclTTSStatePrepared();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();
private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStatePrepared>;
   fc_sxm_tclTTSStatePrepared();
};

class fc_sxm_tclTTSStateStarted :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStateStarted>
{
public:
   virtual ~fc_sxm_tclTTSStateStarted();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStateStarted>;
   fc_sxm_tclTTSStateStarted();
};

class fc_sxm_tclTTSStateQueued :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStateQueued>
{
public:
   virtual ~fc_sxm_tclTTSStateQueued();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStateQueued>;
   fc_sxm_tclTTSStateQueued();
};

class fc_sxm_tclTTSStatePaused :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStatePaused>
{
public:
   virtual ~fc_sxm_tclTTSStatePaused();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStatePaused>;
   fc_sxm_tclTTSStatePaused();
};

class fc_sxm_tclTTSStateResumed :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStateResumed>
{
public:
   virtual ~fc_sxm_tclTTSStateResumed();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStateResumed>;
   fc_sxm_tclTTSStateResumed();
};

class fc_sxm_tclTTSStateAborted :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStateAborted>
{
public:
   virtual ~fc_sxm_tclTTSStateAborted();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStateAborted>;
   fc_sxm_tclTTSStateAborted();
};

class fc_sxm_tclTTSStateStopped :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStateStopped>
{
public:
   virtual ~fc_sxm_tclTTSStateStopped();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStateStopped>;
   fc_sxm_tclTTSStateStopped();
};

class fc_sxm_tclTTSStateError :
   public fc_sxm_tclTTSState,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSStateError>
{
public:
   virtual ~fc_sxm_tclTTSStateError();
   tVoid vDoAction();
   tVoid vPrintStateChangeInfo();

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSStateError>;
   fc_sxm_tclTTSStateError();
};

#endif //_FC_SXM_TCL_TTS_STATES_H_
