/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_tts_context.h
* @brief       Declaration of TTSContext class interfaces.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_TTS_CONTEXT_H_
#define _FC_SXM_TCL_TTS_CONTEXT_H_

#include "fc_sxm_types.h"
#include "fc_sxm_tcl_tts_states.h"

class fc_sxm_tclTTSContext :
   public fc_sxm_tclSingleton<fc_sxm_tclTTSContext>
{
public:
   ~fc_sxm_tclTTSContext();
   tVoid vSetState(fc_sxm_tclTTSState*);
   fc_sxm_tclTTSState* poGetCurrentState();
   tVoid vDoAction();
private:
   fc_sxm_tclTTSContext();
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSContext>;

   fc_sxm_tclTTSState* _poTTSState;
   list<fc_sxm_tclTTSState*> _TTSStateList;
};

#endif
