/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_timer.h
* @brief       Declaration of Timer interfaces which provides timer service to other
*              application
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_TIMER_H
#define FC_SXM_TCL_TIMER_H

class fc_sxm_tclBaseApp;

class fc_sxm_tclTimerBase {
    friend class fc_sxm_tclBaseApp;
    friend tVoid fc_sxm_vTimerCallbackFn(tVoid *pvArg);

 public:
    fc_sxm_tclTimerBase();

    virtual ~fc_sxm_tclTimerBase();

    tBool bIsFired() const;

    tBool bIsRunning() const;

    tVoid vStart(tU32 u32Ms);

    tVoid vStop();

    tU32 u32GetRemainingMs() const;


 protected:
    virtual tVoid vOnCallback()=0;
    tVoid vOnCallback_(fc_sxm_tclBaseApp *poApp) const;
    virtual tVoid vExecute()=0;
    tBool bIsInitialized() const;
    virtual tVoid vRegisterApp()=0;
    virtual tVoid vUnregisterApp()=0;
    tVoid vTraceExecute();
    tBool _bFired;
    tBool _bRunning;
 private:

    OSAL_tTimerHandle _hOsalTmrHandle;


};


template<class APP, class M, class C=APP>
    class fc_sxm_tclTimer: public fc_sxm_tclTimerBase {
    public:
    fc_sxm_tclTimer()
    {};
        
    tVoid vSetMsg(M const &rMsg) {
        _rMsg=rMsg;
    }
            

    virtual tVoid vOnCallback() {
        _bFired=TRUE;
        vOnCallback_(APP::instance());


    }
    protected:
    virtual tVoid vExecute() {
        vTraceExecute();
        if (_bFired) {
            _bFired=FALSE;
            _bRunning=FALSE;
           // C::instance()->vProcess(&_rMsg);
            C::instance()->vProcessTimer(&_rMsg);
        }
    }

    virtual tVoid vRegisterApp() {
        APP::instance()->vRegisterTimer(this);
    }
    virtual tVoid vUnregisterApp() {
        APP::instance()->vUnregisterTimer(this);
    }

    private:
    M _rMsg;
};

template<class APP, class M, class C=APP>
    class fc_sxm_tclObjTimer: public fc_sxm_tclTimerBase {
    public:
    fc_sxm_tclObjTimer(C *poTarget=OSAL_NULL):
    _poTarget(poTarget)
    {};
        
    virtual ~fc_sxm_tclObjTimer() {
        _poTarget = OSAL_NULL;
    }

    tVoid vSetMsg(M const &rMsg) {
        _rMsg=rMsg;
    }
            

    virtual tVoid vOnCallback() {
        _bFired=TRUE;
        vOnCallback_(APP::instance());


    }
    protected:
    virtual tVoid vExecute() {
        vTraceExecute();
        if (_bFired) {
            _bFired=FALSE;
            _bRunning=FALSE;
            if (OSAL_NULL!=_poTarget) {
                _poTarget->vProcess(&_rMsg);
            }
        }
    }

    virtual tVoid vRegisterApp() {
        APP::instance()->vRegisterTimer(this);
    }
    virtual tVoid vUnregisterApp() {
        APP::instance()->vUnregisterTimer(this);
    }

    private:
    M _rMsg;
    C *_poTarget;
};


#endif
