/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sms_init.h
* @brief       This file contains interfaces to register and unregister driver,
*              start, stop and restore module x65.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_SMS_INIT_H_
#define _FC_SXM_TCL_SMS_INIT_H_

#include "fc_sxm_types.h"

typedef enum {
    fc_sxm_enX65PowerState_Off,
    fc_sxm_enX65PowerState_AutoOn,
    fc_sxm_enX65PowerState_On
} fc_sxm_tenX65PowerState;

struct fc_sxm_trSmsThreadPatchInfo {
    fc_sxm_trSmsThreadPatchInfo(string oThreadName, size_t tThreadId, int iOrigPrioVal, int iPatchedPrioVal):
        _oThreadName(oThreadName),
        _tThreadId(tThreadId),
        _iOrigPrioVal(iOrigPrioVal),
        _iPatchedPrioVal(iPatchedPrioVal)
    {}
#if 0
    fc_sxm_trSmsThreadPatchInfo():
        _tThreadId(0),
        _iOrigPrioVal(0),
        _iPatchedPrioVal(0) 
    {}
#endif
    string _oThreadName;
    size_t  _tThreadId;
    int _iOrigPrioVal;
    int _iPatchedPrioVal;
};

class fc_sxm_tclSMSInit:
    public fc_sxm_tclSingleton<fc_sxm_tclSMSInit>

{
        friend class fc_sxm_tclSingleton<fc_sxm_tclSMSInit>;

public:



   //Destructor
   virtual ~fc_sxm_tclSMSInit();

   tBool InitializeSMS(tVoid);
   tVoid vWaitSmsInitialized();
   tBool bWaitSmsDown(tU32 u32MaxMs);
   tBool bWaitDecoderDown(tU32 u32MaxMs);

   static tBool bRegisterDrivers(tVoid *pvArg);
   static tVoid vUnRegisterDrivers(tVoid *pvArg);
   static tBool bStartHandler(const tVoid *pvArg);
   tVoid vStartX65Module();
   tVoid vStopX65Module();
   tVoid vResetX65Module();
   tVoid vRestoreThreadPrios();
   tVoid vSetX65AutoOn();



   // only as interface for SMSLIB!
   tVoid vPatchPrio(string oThreadName, size_t  tThreadId, int &iPrioVal);
   // only as interface for SMSLIB!
   tVoid vSmsLibX65PowerOnRequest();
   // only as interface for SMSLIB!
   tVoid vSmsLibX65PowerOffRequest();


 private:
   //Constructor 
   fc_sxm_tclSMSInit();
   tVoid vInitializeGpios();
   fc_sxm_tenX65PowerState _enX65PowerState;
   tBool _bGpioInitialized;
   tBool _bInSmsInitPhase;
   tU32 _u32X65ResetCounter;
   deque<fc_sxm_trSmsThreadPatchInfo> _qThreadPatchInfos;

};

#endif //_FC_SXM_TCL_SMS_INIT_H_
