/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_singleton.h
* @brief       Template for singleton implementation.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_SINGLETON_H
#define FC_SXM_SINGLETON_H

/*
  template for Singleton-pattern
  Examples can be found in all header-files declaring singleton-classes,
  e.g. fc_sxm_tcl_audio_app.h
*/


template <typename C>
class fc_sxm_tclSingleton {
 public:
    static C* instance ()
    {
        if (!_instance) {
            _instance = OSAL_NEW C;
        }
        return _instance;
    }

    virtual
    ~fc_sxm_tclSingleton ()
    {
       _instance = 0;
    }
 private:
    //lint -esym(1704, fc_sxm_tclSingleton*::fc_sxm_tclSingleton*) prio3 constructor has private access specification
    fc_sxm_tclSingleton(const fc_sxm_tclSingleton<C>&);	
    fc_sxm_tclSingleton& operator=(const fc_sxm_tclSingleton<C>&);
    static C* _instance;
 protected:
    fc_sxm_tclSingleton () { }
 };

 template <typename C> C* fc_sxm_tclSingleton <C>::_instance = 0;


#endif
